//007: RTC Time
#include "twatch.h"
#include "variables.h"
#include "functions.h"

const char* hotspot = "hotspotK";
const char* password = "12345678";
int udpport = 6000;

void setup() 
{
    setupTWATCH();
    setupWIFI(hotspot,password,udpport);
    setFont(1, 255,255,255,  255,0,0);
    backlight(true); 
}

void loop() 
{
    //WiFi-Verbindung herstellen, wenn Knopf gedrückt und falls nicht vorhanden:
    if(button() && !WIFIOKAY) 
    { 
        setupWIFI(hotspot,password,udpport);
    }

    //Beschleunigungswerte aktualisieren:
    acceleration();

    //Wenn WiFi-Verbindung vorhanden und
    //auf Pakete warten aktiviert...
    if(WIFIOKAY && udp.listen(UDPPORT)) 
    {
        //...dann Beschleunigungswerte an PC schicken, wenn dieser
        //etwas gesendet hat:
        udp.onPacket([](AsyncUDPPacket packet) 
        {
                packet.printf("accX=%d accY=%d accZ=%d", accX,accY,accZ);            
        });      
    }        

    cursor(0,0);

    //Beschleunigungswerte auf einfache Art und Weise anzeigen:
    editor(accX);     
    editor('\n');
    editor(accY);     
    editor('\n');
    editor(accZ);     
    editor('\n');
    
    //Falls WiFi Verbindung vorhanden, eigene IP in dem
    //Hotspot-Netz anzeigen:
    if(!WIFIOKAY)
    {
            editor("no WiFi!");
            //editor((unsigned long)millis());
    }
    else
    {
            tft->print(WiFi.localIP()); //...Originalmethode
            //editor(WiFi.localIP()); ...klappt nicht
    }
    editor('\n');
    
    delay(100);  
}
