public interface iRegler
{
     public abstract double berechneStellgroesseU(double[] y);
     public abstract void setParameter(double[] param);
}

public class ZustandsRegler implements iRegler
{
     double[] R = {2.7299999,   0.7904851};
  double FMAX = 0.0;
     public double berechneStellgroesseU(double[] y)
     {
        double phi = y[0];
        double om  = y[1];
        double FA = -R[0]*phi - R[1]*om;
        
        if(FA<FMAX)
        {
             FMAX=FA;
             //println("FA="+FA);
        }
        
        
        if(FA>0.4) FA=0.4;
        if(FA<-0.4) FA=-0.4;
        
        return FA;
     }
     public void setParameter(double[] param)
     {
         R[0] = param[0];
         R[1] = param[1];
     }
}

public class FuzzyRegler implements iRegler
{
  double FMAX = 0.0;
  
     FuzzySystem fs;
  
     public FuzzyRegler()
     {
          //FuzzySystem(double[] breiten, int[] anzahlFuzzyGroessen, int[][] regeln)
          double[] breiten = {1.0,1.0,1.0};
          int[] anzahlFuzzyGroessen = {5,5,5};
          // -- - 0 + ++
          //  0 1 2 3 4
          int[][] regeln = {
              { 4, 4, 3,-1,-1},
              { 4, 3, 3,-1,-1},
              {-1, 3, 2, 1,-1},
              {-1,-1, 1, 1, 0},
              {-1,-1, 1, 0, 0}            
          };
          fs = new FuzzySystem(breiten, anzahlFuzzyGroessen, regeln);
     }
  
     public double berechneStellgroesseU(double[] y)
     {
        double phi = y[0];
        double om  = y[1];
        //double FA = -R[0]*phi - R[1]*om;
        double FA = fs.berechneAusgang(y);
        
        if(FA<FMAX)
        {
             FMAX=FA;
             //println("FA="+FA);
        }
        
        
        if(FA>0.4) FA=0.4;
        if(FA<-0.4) FA=-0.4;
        
        return FA;
     }
     public void setParameter(double[] param)
     {
         fs.setzeBreiten(param);
     }
}
