
int[][] COLOR = {
   {0,0,0},
   {255,0,0},
   {0,255,0},
   {0,0,255}
};

int[][] COLOR2 = {
   {0,255,255},
   {255,0,255},
   {255,255,0},
   {127,127,127}
};

Plotter plotter1,plotter2;
iRegler regler;
public void setup()
{
    //regler = new ZustandsRegler();
    regler = new FuzzyRegler();
    

    iFehlerfunktion ff = new FehlerfunktionFuzzyregler();
    
    ModGradient optimierer = new ModGradient();
    double[] startparameter = {1.0,1.0,1.0};
    optimierer.configure(ff, startparameter);
    
    for(int i=0;i<1000;i++)
       optimierer.iteration();
    double[] bestParam = optimierer.getBestParametersatz();
    println("b1="+bestParam[0]+" b1="+bestParam[1]+" b2="+bestParam[2]);

    
    regler.setParameter(startparameter);
    Simulator simulator = new Simulator(new RungeKuttaIntegrator(),new Einachser(regler));
    double dt = 20.0/3000.0; // 20 Sekunden, 3000 Schritte
    double[][] yt=simulator.exec(dt, 3000, 0.0, new double[] {10.0*Math.PI/180,0.0});
    
    plotter1 = new Plotter(yt,COLOR,width/2,height/2);
    
    regler.setParameter(bestParam);
    simulator = new Simulator(new RungeKuttaIntegrator(),new Einachser(regler));
    yt=simulator.exec(dt, 3000, 0.0, new double[] {10.0*Math.PI/180,0.0});
    
    plotter2 = new Plotter(yt,COLOR2,width/2,height/2);
    
    size(720,480);
    frameRate(30);
}

public void draw()
{
    background(255);
    plotter1.draw(0.0,0.0);
    plotter2.draw(0.0,height/2);
}
