public interface iFehlerfunktion
{
     public abstract double berechneFehler(double[] param);
}

public class FehlerfunktionZustandsregler implements iFehlerfunktion
{  
     Simulator simulator;
     ZustandsRegler regler;
     double[][] yt; //letzte Zeile: t Verlauf
     double dt;
     public FehlerfunktionZustandsregler()
     {
         regler = new ZustandsRegler();
         simulator = new Simulator(new RungeKuttaIntegrator(),new Einachser(regler));
         dt = 20.0/3000.0; // 20 Sekunden, 3000 Schritte
         yt=simulator.exec(dt, 3000, 0.0, new double[] {10.0*Math.PI/180,0.0});
     }
  
     public double berechneFehler(double[] param)
     {
         regler.setParameter(param);
         yt=simulator.exec(dt, 3000, 0.0, new double[] {10.0*Math.PI/180,0.0});
         double errPHI = 0.0;
         double errOM = 0.0;
         for(int i=0;i<yt[0].length;i++)
             errPHI+=yt[0][i]*yt[0][i];
         errPHI = Math.sqrt(errPHI);    
         for(int i=0;i<yt[1].length;i++)
             errOM+=yt[1][i]*yt[1][i];
         errOM = Math.sqrt(errOM);
         return errPHI + errOM;
     }
}
