
int[][] COLOR = {
   {0,0,0},
   {255,0,0},
   {0,255,0},
   {0,0,255}
};

int[][] COLOR2 = {
   {0,255,255},
   {255,0,255},
   {255,255,0},
   {127,127,127}
};

Plotter plotter1,plotter2;
ZustandsRegler regler;
public void setup()
{
    regler = new ZustandsRegler();
    double[][] param = { {1.0,   0.5}, {2.7299999,   0.7904851} };
    
    regler.setParameter(param[0]);
    Simulator simulator = new Simulator(new RungeKuttaIntegrator(),new Einachser(regler));
    double dt = 20.0/3000.0; // 20 Sekunden, 3000 Schritte
    double[][] yt=simulator.exec(dt, 3000, 0.0, new double[] {10.0*Math.PI/180,0.0});
    
    plotter1 = new Plotter(yt,COLOR,width/2,height/2);
    
    regler.setParameter(param[1]);
    simulator = new Simulator(new RungeKuttaIntegrator(),new Einachser(regler));
    yt=simulator.exec(dt, 3000, 0.0, new double[] {10.0*Math.PI/180,0.0});
    
    plotter2 = new Plotter(yt,COLOR2,width/2,height/2);

    FehlerfunktionZustandsregler ff = new FehlerfunktionZustandsregler();
    println("Fehler zu Parametersatz 0: "+ff.berechneFehler(param[0]));
    println("Fehler zu Parametersatz 1: "+ff.berechneFehler(param[1]));
    
    ModGradient optimierer = new ModGradient();
    double[] startparameter = {1.0,1.0};
    optimierer.configure(ff, startparameter);
    
    for(int i=0;i<10000;i++)
       optimierer.iteration();
    double[] bestParam = optimierer.getBestParametersatz();
    println("r1="+bestParam[0]+" r2="+bestParam[1]);
    
    size(720,480);
    frameRate(30);
}

public void draw()
{
    background(255);
    plotter1.draw(0.0,0.0);
    plotter2.draw(0.0,height/2);
}
