public class Simulator
{
     iIntegrator integrator; 
     public Simulator(iIntegrator integrator, iModell modell)
     {
         this.integrator = integrator;
         integrator.configure(modell);
     }
     
     public double[][] exec(double dt, int schritte, double t0, double[] y0)
     {
         double[][] yt = new double[y0.length+1][schritte+1]; //letzte Zeile: t, schritte + AB
         double[] yneu = new double[y0.length];
         double[] yalt = new double[y0.length];
         
         for(int i=0;i<y0.length;i++) //Anfangsbed. auf yalt übertragen.
            yalt[i] = y0[i];
         for(int i=0;i<y0.length;i++) //AB als ersten Eintrag in Ergebnisarray übertragen.
            yt[i][0] = y0[i];
            
         double t = t0;
         yt[yt.length-1][0]=t; //letzte Zeile: t
         for(int i=0;i<schritte;i++)
         {
            integrator.zeitschritt(dt,t,yalt,yneu);
            for(int k=0;k<yalt.length;k++)
                yt[k][i+1] = yneu[k];            
            for(int k=0;k<yalt.length;k++)
                yalt[k] = yneu[k];
            t+=dt;
            yt[yt.length-1][i+1]=t;
         }
            
         return yt;
     }
}
