public class Plotter
{
     double[][] y;
     double[] t;
     int[][] COLOR;
     float xpos, ypos, width, height;
     public Plotter(double[][] yt, int[][] COLOR, float width, float height)
     {
         this.width = width;
         this.height = height;
       
         this.COLOR = COLOR.clone();
       
         //Aufteilung:
         t = yt[yt.length-1];
         y = new double[2][];
         y[0]=yt[0];
         y[1]=yt[1];
         
     }
     
  public void draw(float xpos, float ypos)
  {
    double ymin = findMinimum(y);   
    double ymax = findMaximum(y);
    double tmin = findMinimum(t);   
    double tmax = findMaximum(t);
    double hmax = (double)height;
    double wmax = (double)width;
    double hmin = 0.0;
    double wmin = 0.0;
    
    for(int i=0;i<y.length;i++)
    {
         stroke(COLOR[i][0],COLOR[i][1],COLOR[i][2]);
         float xx1 = (float)mapping(t[0],tmin,tmax,wmin,wmax);
         float yy1 = (float)mapping(y[i][0],ymin,ymax,hmin,hmax);
         for(int k=1;k<y[i].length;k++)
         {
              float xx2 = (float)mapping(t[k],tmin,tmax,wmin,wmax);
              float yy2 = (float)mapping(y[i][k],ymin,ymax,hmin,hmax);
              line(xx1+xpos,height-yy1+ypos,xx2+xpos,height-yy2+ypos);
              xx1=xx2;
              yy1=yy2;
         }
    }       
  }
}
