public class RungeKuttaIntegrator implements iIntegrator
{
     private double[] f;
     private double[] k1,k2,k3,k4;
     private double[] yhilf;
     private iModell modell;
     public void configure(iModell modell)
     {
         f = new double[modell.getAnzahlGleichungen()];
         k1 = new double[modell.getAnzahlGleichungen()];
         k2 = new double[modell.getAnzahlGleichungen()];
         k3 = new double[modell.getAnzahlGleichungen()];
         k4 = new double[modell.getAnzahlGleichungen()];
         yhilf = new double[modell.getAnzahlGleichungen()];
         this.modell = modell;
     }
  
     public void zeitschritt(double dt, double t, double[] yalt, double[] yneu)
     {
        modell.steigung(t,yalt,k1);
        for(int i=0;i<yhilf.length;i++)
            yhilf[i] = yalt[i] + 0.5*dt*k1[i];
            
        modell.steigung(t+0.5*dt,yhilf,k2);            
        for(int i=0;i<yhilf.length;i++)
            yhilf[i] = yalt[i] + 0.5*dt*k2[i];

        modell.steigung(t+0.5*dt,yhilf,k3);            
        for(int i=0;i<yhilf.length;i++)
            yhilf[i] = yalt[i] + dt*k3[i];

        modell.steigung(t+dt,yhilf,k4);

        for(int i=0;i<yneu.length;i++)
            yneu[i] = yalt[i] + (dt/6.0)*(k1[i]+2.0*k2[i]+2.0*k3[i]+k4[i]);                           
     }  
}
