Simulator simulator;
double[][] yt; //letzte Zeile: t Verlauf
double[] t;
double[][] y;

int[][] COLOR = {
   {0,0,0},
   {255,0,0},
   {0,255,0},
   {0,0,255}
};

public void setup()
{
    simulator = new Simulator(new RungeKuttaIntegrator(),new SchwingerModell(0.1,0.01,1.0));
    yt=simulator.exec(0.01, 20000, 0.0, new double[] {1.0,0.0});
    
    //Aufteilung:
    t = yt[yt.length-1];
    y = new double[2][];
    y[0]=yt[0];
    y[1]=yt[1];
    
    size(720,480);
    frameRate(30);
}

public void draw()
{
    background(255);
    double ymin = findMinimum(y);   
    double ymax = findMaximum(y);
    double tmin = findMinimum(t);   
    double tmax = findMaximum(t);
    double hmax = (double)height;
    double wmax = (double)width;
    double hmin = 0.0;
    double wmin = 0.0;
    
    for(int i=0;i<y.length;i++)
    {
         stroke(COLOR[i][0],COLOR[i][1],COLOR[i][2]);
         float xx1 = (float)mapping(t[0],tmin,tmax,wmin,wmax);
         float yy1 = (float)mapping(y[i][0],ymin,ymax,hmin,hmax);
         for(int k=1;k<y[i].length;k++)
         {
              float xx2 = (float)mapping(t[k],tmin,tmax,wmin,wmax);
              float yy2 = (float)mapping(y[i][k],ymin,ymax,hmin,hmax);
              line(xx1,height-yy1,xx2,height-yy2);
              xx1=xx2;
              yy1=yy2;
         }
    }
}
