public interface iAusgangsFuzzySet
{
    /** breite reicht hier bis an die Berührpunkte der äußeren Dreiecke mit der x-Achse */ 
    public abstract void setzeStuetzpunkte(double breite); 
    /**
        int[][] regeln: jede Eingangsgröße der beiden E.-Fuzzysets mit jeder kombiniert beeinflusst 
        eine Fuzzy-Größe des Ausgangsfuzzysets. Letztere ist im Array eingetragen als Index.
        double[][] aktivierungen: aktuell aus der Eingangssituation resultierende Aktivierungen jeder
        Regel korrespondierend mit int[][] regeln.
    */
    public abstract double berechneSchwerpunkt(int[][] regeln, double[][] aktivierungen); 
     
}

public class AusgangsFuzzySet implements iAusgangsFuzzySet
{
    int anzahlFuzzygroessen;
    double breite;
    
    public AusgangsFuzzySet(int anzahlFuzzygroessen, double breite)
    {
        this.anzahlFuzzygroessen = anzahlFuzzygroessen;
        this.breite = breite;
    }
  
    public void setzeStuetzpunkte(double breite)
    {
        this.breite = breite;
    }
    public double berechneErfuelltheitsgrad(int index, double x)
    {
        //double d = breite/(double)(anzahlFuzzygroessen-1);
        double d = breite/(double)(anzahlFuzzygroessen+1); //!!!
        double m = 1.0/d;
        
        if(x<=-breite*0.5)
        {
            return 0.0;
        }
        else if(x>=breite*0.5)
        {
            return 0.0;
        }
        else if(x<=-breite*0.5+d) //linker Rand
        {
            if(index==0)
                return (x-(-breite*0.5))*m;
            else
                return 0.0;
        }
        else if(x>=breite*0.5-d) //rechter Rand
        {
            if(index==anzahlFuzzygroessen-1)
                return 1.0-(x-(breite*0.5-d))*m;
            else
                return 0.0;
        }
        else
        {
             //Bereiche durchgehen:
//             for(int i=0;i<anzahlFuzzygroessen-1;i++)
             for(int i=1;i<anzahlFuzzygroessen;i++) //!!!
             {
                  if(x>=-breite*0.5+d*(double)i && x<=-breite*0.5+(double)(i+1)*d)
                  {
                      //Index beteiligter Fuzzy-Größen ist hier:
                      //   i und i+1
                      //Wenn linke der Fuzzy-Größen ...
                      //if(index==i)
                      if(index==i-1)//!!!
                      {
                           return 1.0 - m*(x-(-breite*0.5+d*(double)i)); //ist komplementär zur zweiten
                      }
                      //Wenn gefragte Fuzzy-Größe rechte der aktuell betrachteten...
                      //else if(index==i+1)
                      else if(index==i) //!!!
                      {
                           //dann Steigung positiv berücksichtigen:
                           return m*(x-(-breite*0.5+d*(double)i));
                      }
                  }
             }
        }
        return 0.0;
    }
    
    public double berechneSchwerpunkt(int[][] regeln, double[][] aktivierungen)
    {
          double A=0.0; //"Fläche"
          double s=0.0; //Schwerpunkt
          
          double d = breite/(double)(anzahlFuzzygroessen+1); //!!!
          
          for(int i=0;i<regeln.length;i++)
          {
               for(int k=0;k<regeln[i].length;k++)
               {
                    //Mittelposition der Ausgangsfuzzygröße der Regel bestimmen:
                    double x = -breite*0.5+(regeln[i][k]+1)*d;
                    A+=aktivierungen[i][k];
                    s+=x*aktivierungen[i][k];
               }
          }
          
          if(A>0.0)
             return s/A;
          else
             return 0.0;
    }
    
}
