public interface iEingangsFuzzySet
{
    /**
         breite ist der Abstand zwischen der am weitesten links liegenden Fuzzy-Größe und
         der am weitesten rechts liegenden.
         Alle Fuzzy-Größen werden äquidistant angeordnet.
    */
    public abstract void setzeStuetzpunkte(double breite); 
    /** Liefert Erfülltheitsgrad einer bestimmten Fuzzy-Größe */
    public abstract double berechneErfuelltheitsgrad(int index, double x);    
}

public class EingangsFuzzySet implements iEingangsFuzzySet
{
    int anzahlFuzzygroessen;
    double breite;
    
    public EingangsFuzzySet(int anzahlFuzzygroessen, double breite)
    {
        this.anzahlFuzzygroessen = anzahlFuzzygroessen;
        this.breite = breite;
    }
  
    public void setzeStuetzpunkte(double breite)
    {
    }
    public double berechneErfuelltheitsgrad(int index, double x)
    {
        double d = breite/(double)(anzahlFuzzygroessen-1);
        double m = 1.0/d;
        
        if(x<=-breite*0.5)
        {
             if(index==0)
                return 1.0;
             else
                return 0.0;
        }
        else if(x>=breite*0.5)
        {
             if(index==anzahlFuzzygroessen-1)
                return 1.0;
             else
                return 0.0;
        }
        else //...
        {
          
        }
    }
}
