import java.util.Random;

Random zufall = new Random(System.currentTimeMillis());

public int[][] erzeugeZufallsmatrix(int zeilen, int spalten)
{
    int[][] arr = new int[zeilen][spalten];
    
    for(int i=0;i<arr.length;i++)
       for(int k=0;k<arr[i].length;k++)
          arr[i][k] = zufall.nextInt(2);
    return arr;      
}

public void showArray(int[][] arr)
{
    println();
    for(int i=0;i<arr.length;i++)
    {
       for(int k=0;k<arr[i].length;k++)
       {
          print(arr[i][k]+" ");
       }   
       println();
    }      
}

public void drawArray(int[][] arr, float x, float y, float w)
{
    float d = w/(float)arr.length;
    noStroke();
    for(int i=0;i<arr.length;i++)
    {
       for(int k=0;k<arr[i].length;k++)
       {
           if(arr[i][k]>0)
              fill(0);
           else
              fill(255);
           rect(x+(float)k*d,y+(float)i*d,w,w);   
       }   
    }      
}
    int KANTE=16;
    int[][] allerbestes = new int[KANTE][KANTE];
    int[][][] gen = new int[100][][];
    int[][][] beste = new int[10][][];
    double[] fehler = new double[gen.length];

public void setup()
{
    size(600,600);
    frameRate(5);
    
    for(int i=0;i<gen.length;i++)
       gen[i] = erzeugeZufallsmatrix(KANTE, KANTE);
        
}

public void neueGeneration()
{
         //1. Fehler für alle Gene bestimmen:
         for(int i=0;i<fehler.length;i++)
             fehler[i] = fehlerfunktion(gen[i]);
         //2. Beste finden:
         for(int i=0;i<beste.length;i++)
         {
              int inx=-1;
              double errBest = Double.MAX_VALUE;
              for(int k=0;k<fehler.length;k++)
              {
                   if(fehler[k]<=errBest)
                   {
                        errBest = fehler[k];
                        inx=k;
                   }
              }
              beste[i]=gen[inx].clone();
              if(i==0)
              {
                  for(int u=0;u<beste[i].length;u++)
                     for(int v=0;v<beste[i][u].length;v++)
                         allerbestes[u][v]=beste[i][u][v];
              }    
              fehler[inx]=Double.MAX_VALUE; //damit er beim nächsten Durchlauf nicht verwendet wird
         }
         
         //3. Rekombination
         for(int i=0;i<beste.length;i++)
            gen[i]=beste[i].clone();
         for(int i=beste.length;i<gen.length;i++)
         {
            int inx1 = zufall.nextInt(beste.length);
            int inx2 = (inx1+1+zufall.nextInt(beste.length-1))%beste.length;
            for(int u=0;u<gen[i].length;u++)
                for(int v=0;v<gen[i][u].length;v++)
                   if(zufall.nextBoolean())
                       gen[i][u][v] = beste[inx1][u][v];
                   else    
                       gen[i][u][v] = beste[inx2][u][v];
         }
}

public void draw()
{
    background(255);
    //int[][] x = erzeugeZufallsmatrix(60, 60);
    neueGeneration();
    drawArray(allerbestes, 0, 0, width);
}
