public interface iAusgangsFuzzySet
{
    /** breite reicht hier bis an die Berührpunkte der äußeren Dreiecke mit der x-Achse */ 
    public abstract void setzeStuetzpunkte(double breite); 
    /**
        int[][] regeln: jede Eingangsgröße der beiden E.-Fuzzysets mit jeder kombiniert beeinflusst 
        eine Fuzzy-Größe des Ausgangsfuzzysets. Letztere ist im Array eingetragen als Index.
        double[][] aktivierungen: aktuell aus der Eingangssituation resultierende Aktivierungen jeder
        Regel korrespondierend mit int[][] regeln.
    */
    public abstract double berechneSchwerpunkt(int[][] regeln, double[][] aktivierungen); 
     
}

public class AusgangsFuzzySet implements iAusgangsFuzzySet
{
    //NEU *** NEU *** NEU
    double OFFSET = 0.0;
    //NEU *** NEU *** NEU
    
    int anzahlFuzzygroessen;
    double breite;
    
    public AusgangsFuzzySet(int anzahlFuzzygroessen, double breite)
    {
        this.anzahlFuzzygroessen = anzahlFuzzygroessen;
        this.breite = breite;
    }
  
    //NEU *** NEU *** NEU
    public AusgangsFuzzySet(int anzahlFuzzygroessen, double breite, double OFFSET)
    {
        this.anzahlFuzzygroessen = anzahlFuzzygroessen;
        this.breite = breite;
        this.OFFSET = OFFSET;
    }
    //NEU *** NEU *** NEU
  
    public void setzeStuetzpunkte(double breite)
    {
        this.breite = breite;
    }
    public double berechneErfuelltheitsgrad(int index, double x)
    {
        //double d = breite/(double)(anzahlFuzzygroessen-1);
        double d = breite/(double)(anzahlFuzzygroessen+1); //!!!
        double m = 1.0/d;
        
        if(x<=-breite*0.5)
        {
            return 0.0;
        }
        else if(x>=breite*0.5)
        {
            return 0.0;
        }
        else if(x<=-breite*0.5+d) //linker Rand
        {
            if(index==0)
                return (x-(-breite*0.5))*m;
            else
                return 0.0;
        }
        else if(x>=breite*0.5-d) //rechter Rand
        {
            if(index==anzahlFuzzygroessen-1)
                return 1.0-(x-(breite*0.5-d))*m;
            else
                return 0.0;
        }
        else
        {
             //Bereiche durchgehen:
//             for(int i=0;i<anzahlFuzzygroessen-1;i++)
             for(int i=1;i<anzahlFuzzygroessen;i++) //!!!
             {
                  if(x>=-breite*0.5+d*(double)i && x<=-breite*0.5+(double)(i+1)*d)
                  {
                      //Index beteiligter Fuzzy-Größen ist hier:
                      //   i und i+1
                      //Wenn linke der Fuzzy-Größen ...
                      //if(index==i)
                      if(index==i-1)//!!!
                      {
                           return 1.0 - m*(x-(-breite*0.5+d*(double)i)); //ist komplementär zur zweiten
                      }
                      //Wenn gefragte Fuzzy-Größe rechte der aktuell betrachteten...
                      //else if(index==i+1)
                      else if(index==i) //!!!
                      {
                           //dann Steigung positiv berücksichtigen:
                           return m*(x-(-breite*0.5+d*(double)i));
                      }
                  }
             }
        }
        return 0.0;
    }
    
    public double berechneSchwerpunkt(int[][] regeln, double[][] aktivierungen)
    {
          double A=0.0; //"Fläche"
          double s=0.0; //Schwerpunkt
          
          double d = breite/(double)(anzahlFuzzygroessen+1); //!!!
          
          for(int i=0;i<regeln.length;i++)
          {
               for(int k=0;k<regeln[i].length;k++)
               {
                    //Mittelposition der Ausgangsfuzzygröße der Regel bestimmen:
                    //NEU *** NEU *** NEU
                    if(regeln[i][k]>=0) //so auch fehlende Regeln möglich!!!
                    {
                        double x = -breite*0.5+(double)(regeln[i][k]+1)*d;
                        
                        A+=aktivierungen[i][k];
                        s+=x*aktivierungen[i][k];
                    }
                    //NEU *** NEU *** NEU
               }
          }
          
          if(A>0.0)
             return s/A+OFFSET; //NEU *** NEU *** NEU
          else
             return 0.0+OFFSET; //NEU *** NEU *** NEU
    }
    
}

public interface iEingangsFuzzySet
{
    /**
         breite ist der Abstand zwischen der am weitesten links liegenden Fuzzy-Größe und
         der am weitesten rechts liegenden.
         Alle Fuzzy-Größen werden äquidistant angeordnet.
    */
    public abstract void setzeStuetzpunkte(double breite); 
    /** Liefert Erfülltheitsgrad einer bestimmten Fuzzy-Größe */
    public abstract double berechneErfuelltheitsgrad(int index, double x);    
}

public class EingangsFuzzySet implements iEingangsFuzzySet
{
    //NEU *** NEU *** NEU
    double OFFSET = 0.0;
    //NEU *** NEU *** NEU
  
    int anzahlFuzzygroessen;
    double breite;
    
    public EingangsFuzzySet(int anzahlFuzzygroessen, double breite)
    {
        this.anzahlFuzzygroessen = anzahlFuzzygroessen;
        this.breite = breite;
    }
    
    //NEU *** NEU *** NEU
    public EingangsFuzzySet(int anzahlFuzzygroessen, double breite, double OFFSET)
    {
        this.anzahlFuzzygroessen = anzahlFuzzygroessen;
        this.breite = breite;
        this.OFFSET = OFFSET;
    }
    //NEU *** NEU *** NEU
  
    public void setzeStuetzpunkte(double breite)
    {
        this.breite = breite; //das reicht.
    }
    public double berechneErfuelltheitsgrad(int index, double x)
    {
        //NEU *** NEU *** NEU
        x-=OFFSET;
        //NEU *** NEU *** NEU
        
        double d = breite/(double)(anzahlFuzzygroessen-1);
        double m = 1.0/d;
        
        if(x<=-breite*0.5)
        {
             if(index==0)
                return 1.0;
             else
                return 0.0;
        }
        else if(x>=breite*0.5)
        {
             if(index==anzahlFuzzygroessen-1)
                return 1.0;
             else
                return 0.0;
        }
        else //...
        {
             //Bereiche durchgehen:
             for(int i=0;i<anzahlFuzzygroessen-1;i++)
             {
                  if(x>=-breite*0.5+d*(double)i && x<=-breite*0.5+(double)(i+1)*d)
                  {
                      //Index beteiligter Fuzzy-Größen ist hier:
                      //   i und i+1
                      //Wenn linke der Fuzzy-Größen ...
                      if(index==i)
                      {
                           return 1.0 - m*(x-(-breite*0.5+d*(double)i)); //ist komplementär zur zweiten
                      }
                      //Wenn gefragte Fuzzy-Größe rechte der aktuell betrachteten...
                      else if(index==i+1)
                      {
                           //dann Steigung positiv berücksichtigen:
                           return m*(x-(-breite*0.5+d*(double)i));
                      }
                  }
             }
        }
        return 0.0;
    }
}

public interface iFuzzySystem
{
     public abstract double berechneAusgang(double[] y);
     public abstract double berechneAktivierung(double[] y, int i, int k); //...einer einzelnen Regel.
     /** obere neue Breiten für Eingangsfuzzysets, unterste ist die Breite für das Ausgangsfuzzyset */
     public abstract void setzeBreiten(double[] breiten);
}


public class FuzzySystem implements iFuzzySystem //...mit zwei Eingangsfuzzysets und einem Ausgangsfuzzyset
{
     iEingangsFuzzySet in1;
     iEingangsFuzzySet in2;
     iAusgangsFuzzySet out;
     int[][] regeln;
     double[][] aktivierungen;
     public FuzzySystem(double[] breiten, int[] anzahlFuzzyGroessen, int[][] regeln)
     {
         in1 = new EingangsFuzzySet(anzahlFuzzyGroessen[0],breiten[0]);
         in2 = new EingangsFuzzySet(anzahlFuzzyGroessen[1],breiten[1]);
         out = new AusgangsFuzzySet(anzahlFuzzyGroessen[2],breiten[2]);
         this.regeln = regeln.clone();
         aktivierungen = new double[regeln.length][regeln[0].length];
     }
     
     public FuzzySystem(double[] OFFSETS, double[] breiten, int[] anzahlFuzzyGroessen, int[][] regeln)
     {
         in1 = new EingangsFuzzySet(anzahlFuzzyGroessen[0],breiten[0],OFFSETS[0]);
         in2 = new EingangsFuzzySet(anzahlFuzzyGroessen[1],breiten[1],OFFSETS[1]);
         out = new AusgangsFuzzySet(anzahlFuzzyGroessen[2],breiten[2],OFFSETS[2]);
         this.regeln = regeln.clone();
         aktivierungen = new double[regeln.length][regeln[0].length];
     }
     
     public double berechneAusgang(double[] y)
     {
         for(int i=0;i<regeln.length;i++)
         {
               for(int k=0;k<regeln[i].length;k++)
               {
                    double p = in1.berechneErfuelltheitsgrad(i, y[0]);
                    double q = in2.berechneErfuelltheitsgrad(k, y[1]);
                    aktivierungen[i][k] = p;
                    if(q<p)
                       aktivierungen[i][k] = q;
               }
         }
       
         return out.berechneSchwerpunkt(regeln,aktivierungen);
     }
     
     public double berechneAktivierung(double[] y, int i, int k) //...einer einzelnen Regel.
     {
                    double p = in1.berechneErfuelltheitsgrad(i, y[0]);
                    double q = in2.berechneErfuelltheitsgrad(k, y[1]);
                    double aktivierung = p;
                    if(q<p)
                       aktivierung = q;
       
         return aktivierung;
     }
     
     public void setzeBreiten(double[] breiten)
     {
        in1.setzeStuetzpunkte(breiten[0]);   
        in2.setzeStuetzpunkte(breiten[1]);   
        out.setzeStuetzpunkte(breiten[2]);   
     }
}
