public interface iFuzzySystem
{
     public abstract double berechneAusgang(double[] y);
     public abstract double berechneAktivierung(double[] y, int i, int k); //...einer einzelnen Regel.
     /** obere neue Breiten für Eingangsfuzzysets, unterste ist die Breite für das Ausgangsfuzzyset */
     public abstract void setzeBreiten(double[] breiten);
}


public class FuzzySystem implements iFuzzySystem //...mit zwei Eingangsfuzzysets und einem Ausgangsfuzzyset
{
     iEingangsFuzzySet in1;
     iEingangsFuzzySet in2;
     iAusgangsFuzzySet out;
     int[][] regeln;
     double[][] aktivierungen;
     public FuzzySystem(double[] breiten, int[] anzahlFuzzyGroessen, int[][] regeln)
     {
         in1 = new EingangsFuzzySet(anzahlFuzzyGroessen[0],breiten[0]);
         in2 = new EingangsFuzzySet(anzahlFuzzyGroessen[1],breiten[1]);
         out = new AusgangsFuzzySet(anzahlFuzzyGroessen[2],breiten[2]);
         this.regeln = regeln.clone();
         aktivierungen = new double[regeln.length][regeln[0].length];
     }
     
     public FuzzySystem(double[] OFFSETS, double[] breiten, int[] anzahlFuzzyGroessen, int[][] regeln)
     {
         in1 = new EingangsFuzzySet(anzahlFuzzyGroessen[0],breiten[0],OFFSETS[0]);
         in2 = new EingangsFuzzySet(anzahlFuzzyGroessen[1],breiten[1],OFFSETS[1]);
         out = new AusgangsFuzzySet(anzahlFuzzyGroessen[2],breiten[2],OFFSETS[2]);
         this.regeln = regeln.clone();
         aktivierungen = new double[regeln.length][regeln[0].length];
     }
     
     public double berechneAusgang(double[] y)
     {
         for(int i=0;i<regeln.length;i++)
         {
               for(int k=0;k<regeln[i].length;k++)
               {
                    double p = in1.berechneErfuelltheitsgrad(i, y[0]);
                    double q = in2.berechneErfuelltheitsgrad(k, y[1]);
                    aktivierungen[i][k] = p;
                    if(q<p)
                       aktivierungen[i][k] = q;
               }
         }
       
         return out.berechneSchwerpunkt(regeln,aktivierungen);
     }
     
     public double berechneAktivierung(double[] y, int i, int k) //...einer einzelnen Regel.
     {
                    double p = in1.berechneErfuelltheitsgrad(i, y[0]);
                    double q = in2.berechneErfuelltheitsgrad(k, y[1]);
                    double aktivierung = p;
                    if(q<p)
                       aktivierung = q;
       
         return aktivierung;
     }
     
     public void setzeBreiten(double[] breiten)
     {
        in1.setzeStuetzpunkte(breiten[0]);   
        in2.setzeStuetzpunkte(breiten[1]);   
        out.setzeStuetzpunkte(breiten[2]);   
     }
}
