import java.util.Random;

public interface iOptimierer
{
     public abstract void configure(iFehlerfunktion fehlerfunktion, double[] startparameter);
     
     public abstract void iteration();
     
     public abstract double[] getBestParametersatz();
}

public class ModGradient implements iOptimierer
{
     Random zufall;
     iFehlerfunktion fehlerfunktion;
     double bestFehler;
     double[] pakt; //aktueller Parametersatz
     public void configure(iFehlerfunktion fehlerfunktion, double[] startparameter)
     {
          zufall = new Random(System.currentTimeMillis());
          this.fehlerfunktion = fehlerfunktion;
          bestFehler = fehlerfunktion.berechneFehler(startparameter);
          pakt = new double[startparameter.length];
          for(int i=0;i<pakt.length;i++)
              pakt[i]=startparameter[i];
          //   pakt = startparameter.clone();    
     }
     
     public void iteration()
     {
          int index = zufall.nextInt(pakt.length);
          double[] pneu = pakt.clone();
          double alfa = 0.01;
          if(zufall.nextBoolean())
          {
                pneu[index] += alfa;            
          }
          else
          {
                pneu[index] -= alfa;            
          }
          double neuerFehler = fehlerfunktion.berechneFehler(pneu);
          
          if(neuerFehler<=bestFehler)
          {
               if(neuerFehler<bestFehler)
                  println("err="+neuerFehler);
            
               for(int i=0;i<pneu.length;i++)
                  pakt[i]=pneu[i];
               bestFehler=neuerFehler;   
          }
          else
          {
          }
     }
     
     public double[] getBestParametersatz()
     {
          return pakt;
     }
}
