!!!KURZSCHRIFT
#hauptkapitel
Simulations- u. Regelungstechnik im Wintersemester 2025/26 

#ul
Studierendengruppen: 5-3-MT

#ul
Hier bei "day by day" werden chronologisch im Verlauf des Semesters die behandelten Inhalte vermerkt.
Meistens werden Links innerhalb von kramann.info angegeben, wo der jeweils behandelte Stoff dargestellt wird.
Zur Orientierung finden Sie auf kramann.info auch noch das "day by day" der gleichen Lehrveranstaltung vom vorangehenden Jahr.
Die Prfung in diesem Fach ist eine Klausur in elektronischer Form (E-Test)

#h1
SRT am Dienstag den 16.11.2025 -- TEIL 1: FUZZY LOGIK, FUZZY SYSTEME, FUZZY REGLER

#h4
Themen

#ol
berblick
Fuzzy-Logik
Fuzzy-Regler
bungen

#h4
1. berblick

#p
In der Lehrveranstaltung Simulations- und Regelungstechnik 2 werden 
Themen aus der ersten Vorlesung, wie der Zustandsregler, weiter vertieft und Sonderthemen, wie beispielsweise Fuzzy-Regler, neu eingefhrt.
Auch erhlt das Thema Optimierung ein greres Gewicht.

#h4
2. Fuzzy-Logik

#aint
62_Regelungssysteme/18_Fuzzy
62_Regelungssysteme/18_Fuzzy
62_Regelungssysteme/18_Fuzzy -- Theorie

#aint
62_Regelungssysteme/18_Fuzzy/03_Uebung9
62_Regelungssysteme/18_Fuzzy/03_Uebung9
62_Regelungssysteme/18_Fuzzy/03_Uebung9 -- Beispiel 1

#aint
02_WS2021_22/05_REGmecha5/01_day_by_day
02_WS2021_22/05_REGmecha5/01_day_by_day
02_WS2021_22/05_REGmecha5/01_day_by_day -- Beispiel 2

#aint
72_COACH2/12_Fuzzy/01_Uebungsaufgabe
72_COACH2/12_Fuzzy/01_Uebungsaufgabe
72_COACH2/12_Fuzzy/01_Uebungsaufgabe -- bung

#aint
80_Robuste_Systemintegration/10_EvoFuzzy
80_Robuste_Systemintegration/10_EvoFuzzy
80_Robuste_Systemintegration/10_EvoFuzzy -- Preview: Aufbau von Fuzzy-Reglern und deren Optimierung ber Evolutionre Algorithmen

#h4
3. Fuzzy-Regler

#img
f1.png
Beispiel fr einem Fuzzy-Regler.

#h5
bung: Ersetze den Zustandsregler unten durch einen Fuzzy-Regler

#img
f2.png
Umzusetzender Fuzzy-Regler (gleiche Geometrie wie oben, aber andere Regeln und erweitertes Ausgangsfuzzyset)

#code
clear;

function F = fregler(x,v)
    F = -x-v;
endfunction

function f = rechteSeite(t,y)
    x = y(1,1);
    v = y(2,1);

    F = fregler(x,v);

    f(1,1) =  v;
    f(2,1) = -x + F;
endfunction

t = 0:0.01:10;
y0 = [2,0]';
t0 = 0;
y  = ode(y0,t0,t,rechteSeite);

plot(t,y(1,:)',t,y(2,:)');
Rahmensystem, in dem der Zustandsregler durch die Implementierung eines Fuzzy-Reglers ersetzt werden soll.

#code
clear;

function nzp = fuzzysetX(x)

endfunction
function nzp = fuzzysetV(v)

endfunction

function F = fregler(x,v)
   // 1. Fuzzifizieren der Eingangsgren x und v, heit: zu jeder Fuzzygre
   //    jedes der beiden Eingangsfuzzysets wird der Erflltheitsgrad berechnet.
   nzp_x = fuzzysetX(x);
   nzp_v = fuzzysetX(v);
   // 2. Erflltheitsgrade jeder Regel berechnen
   erfuelltheit = zeros(9);
   erfuelltheit(1) = min(nzp_x(1),nzp_v(1));
//...
   // 3. Defuzzifizierung der Ausgangsgre (Kraft F), heit Schwerpunktberechnung.


endfunction

function f = rechteSeite(t,y)
    x = y(1,1);
    v = y(2,1);

    F = fregler(x,v);

    f(1,1) =  v;
    f(2,1) = -x + F;
endfunction

t = 0:0.01:10;
y0 = [2,0]';
t0 = 0;
y  = ode(y0,t0,t,rechteSeite);

plot(t,y(1,:)',t,y(2,:)');
Noch unfertige Umsetzung, jedoch mit kompletter Programmstruktur.

#code
clear;

function A=flaecheTrapez(h)
    q = 2.0;
    p = 2.0*(1.0-h);
    A = h*(p+q)/2.0;
end

function nzp = fuzzysetX(x)
   nzp = zeros(3);
   if x<-1 then
      nzp(1)=1.0;
      nzp(2)=0.0;
      nzp(3)=0.0;
   elseif x<0 then
      nzp(1)=-x;
      nzp(2)=1-nzp(1);
      nzp(3)=0.0;
   elseif x<1 then
      nzp(3)=x;
      nzp(2)=1-nzp(3);
      nzp(1)=0;
   else
      nzp(1)=0.0;
      nzp(2)=0.0;
      nzp(3)=1.0;
   end
endfunction

function nzp = fuzzysetV(v)
   nzp = zeros(3);
   if v<-1 then
      nzp(1)=1.0;
      nzp(2)=0.0;
      nzp(3)=0.0;
   elseif v<0 then
      nzp(1)=-v;
      nzp(2)=1-nzp(1);
      nzp(3)=0.0;
   elseif v<1 then
      nzp(1)=0.0;
      nzp(3)=v;
      nzp(2)=1-nzp(3);
   else
      nzp(1)=0.0;
      nzp(2)=0.0;
      nzp(3)=1.0;
   end
endfunction

function erg=mini(x,y)
   if x<y then
      erg=x;
   else
      erg=y;
   end
end

function F = fregler(x,v)
   // 1. Fuzzifizieren der Eingangsgren x und v, heit: zu jeder Fuzzygre
   //    jedes der beiden Eingangsfuzzysets wird der Erflltheitsgrad berechnet.
   nzp_x = fuzzysetX(x);
   nzp_v = fuzzysetV(v);
   // 2. Erflltheitsgrade jeder Regel berechnen
   ef = zeros(9); //erfuelltheit
   ef(1) = mini(nzp_x(1),nzp_v(1)); //Regel 1
   ef(2) = mini(nzp_x(2),nzp_v(1)); //Regel 2
   ef(3) = mini(nzp_x(3),nzp_v(1)); //...
   ef(4) = mini(nzp_x(1),nzp_v(2));
   ef(5) = mini(nzp_x(2),nzp_v(2));
   ef(6) = mini(nzp_x(3),nzp_v(2));
   ef(7) = mini(nzp_x(1),nzp_v(3));
   ef(8) = mini(nzp_x(2),nzp_v(3));
   ef(9) = mini(nzp_x(3),nzp_v(3));


//...
   //F = F/Ages;
   // 3. Defuzzifizierung der Ausgangsgre (Kraft F), heit Schwerpunktberechnung.
   F=0.0;
   Ages=0.0;   

   sp=[2,1,0,1,0,-1,0,-1,-2];

   //Regel 1..9:
   for i=1:9
     A=flaecheTrapez(ef(i));
     s=sp(i);   
     Ages=Ages+A;
     F=F+s*A;
   end


   F=F/Ages;
endfunction

function f = rechteSeite(t,y)
    x = y(1,1);
    v = y(2,1);
    F = fregler(x,v);
    f(1,1) =  v;
    f(2,1) = -x + F;
endfunction

t = 0:0.01:10;
y0 = [2,0]';
t0 = 0;
y  = ode(y0,t0,t,rechteSeite);

plot(t,y(1,:)',t,y(2,:)');

Komplettes System.

#h4
4. bungen

#h5
Aufgabe 1

#p
Am Eingang eines Fuzzy-Systems liegen folgende Werte an: x=2, y=-1

#img
fuz.png
Fuzzy-System.

#p
Die Fuzzy-Regeln lauten:

#code

r1: WENN xgross UND ygross DANN Fklein
r2: WENN xgross UND yklein DANN Fklein
r3: WENN xklein UND ygross DANN Fgross
r4: WENN xklein UND yklein DANN Fgross

Fuzzy-Regeln

#p
Geben Sie den Erflltheitsgrad zu jeder Regel an.

#code
r1=...
r2=...
r3=...
r4=...
Erflltheitsgrad zu jeder Regel.

#h5
Aufgabe 2

#img
fuzzy.png
Fuzzy-System.

#ul
Oben ist ein Fuzzy-System komplett mit den Fuzzy-Regeln gegeben.
Implementieren Sie dieses System als Funktion in Java-Processing und C.
Der Kopf der Funktion soll folgende Form haben: double berechneC(double A, double B).
Erstellen Sie mit Hilfe der Funktion eine Wertetabelle, in der im relevanten Bereich A und B kombiniert werden und C berechnet wird.

#h1
SRT am Dienstag den 16.11.2025 -- TEIL 2: OBJEKTORIENTIERTE PROGRAMMIERUNG

#ol
Einfhrung in Java-Processing
Einfhrung in die Objektorientierte Programmierung mit Java-Processing

#h5
Studentische Lsung

#code
clear;
mode(0);
clc;

A=3.5;
B=2.5;

function a = SystemA(A)
    if A<=2 then
        a(1)=1;
        a(2)=0;
        a(3)=0;
    end
    if A>2 && A<=3 then
        a(1)=-A+3;
        a(2)=A-2;
        a(3)=0;
    end
    if A>3 && A<=4 then
        a(1)=0;
        a(2)=-A+4;
        a(3)=A-3;
    end
    if A>4 then
        a(1)=0;
        a(2)=0;
        a(3)=1;
    end
endfunction

function b = SystemB(B)
    if B<=2 then
        b(1)=1;
        b(2)=0;
        b(3)=0;
    end
    if B>2 && B<=3 then
        b(1)=-B+3;
        b(2)=B-2;
        b(3)=0;
    end
    if B>3 && B<=4 then
        b(1)=0;
        b(2)=-B+4;
        b(3)=B-3;
    end
    if B>4 then
        b(1)=0;
        b(2)=0;
        b(3)=1;
    end
endfunction

function A=flaecheTrapez(h)
    q = 2.0;
    p = 2.0*(1.0-h);
    A = h*(p+q)/2.0;
end

function C = berechneC (A,B)
    a=SystemA(A);
    b=SystemB(B);
    
    Reg1=min(a(1),b(3));
    Reg2=min(a(2),b(2));
       
    A1=flaecheTrapez(Reg1);
    A2=flaecheTrapez(Reg2);
    
    s1=4;
    s2=5;
    
    C=(s1*A1+s2*A2)/(A1+A2);
    pause;
endfunction

C=berechneC(A,B);

Studentische Lsung zu Aufgabe 2.

#h4
1. Einfhrung in Java-Processing

#aint
78_Processing
78_Processing
78_Processing

#zip
SRT001.zip
SRT001.zip -- Lsung zu Aufgabe 2 oben mit Java-Procressing.

#code
public class Vektor
{
     double x,y;
     
     public double berechneLaenge()
     {
         return Math.sqrt(x*x+y*y);
     }
}


public void setup()
{
    Vektor v1,v2;
    v1 = new Vektor();
    v2 = new Vektor();
    
    v1.x = 3.0;
    v1.y = 4.0;
    
    v2.x = 1.0;
    v2.y = 0.0;
    
    println("Lnge v1: "+v1.berechneLaenge());
    println("Lnge v2: "+v2.berechneLaenge());
}

public void draw()
{
}
Konzept der Objektorientierung am Beispiel des mathematischen R2-Vektors

#zip
SRT003.zip
SRT003.zip -- Aufgabe 2 in Klasse gepackt.

#zip
SRT004.zip
SRT004.zip -- Einsatz der Konstruktormethode.



#h4
2. Einfhrung in die Objektorientierte Programmierung mit Java-Processing

#aint
30_Informatik3/01_Vom_struct_zur_Klasse/06_Objektabstraktion
30_Informatik3/01_Vom_struct_zur_Klasse/06_Objektabstraktion
Allgemein: 30_Informatik3/01_Vom_struct_zur_Klasse/06_Objektabstraktion


#h1
SRT am Montag den 24.11.2025 -- Fortsetzung TEIL 2: OBJEKTORIENTIERTE PROGRAMMIERUNG

#ol
Paradigmen der Objektorientierten Programmierung und UML
Schnittstellen / Interfaces am Beispiel eines Simulationsprogramms
Planung der objektorientierten Implementierung eines Fuzzy-Reglers 
Vergleich: Objektorientierte Programmierung mit Java C/C++
Einfhrung in Android-Processing
Einrichtung eines Hotspots unter Linux und unter Android
Programmierung von Anwendungen mit UDP

#h4
1. Paradigmen der Objektorientierten Programmierung und UML

#p
...vergl. Vorlesung / werden anhand der nachfolgenden Beispiele erlutert:

#ol
Kapselung
Vererbung
Polymorphismus (Overloading)
Abstraktion
Wiederverwendbarkeit

#aint
30_Informatik3/02_UML
30_Informatik3/02_UML
30_Informatik3/02_UML

#aint
30_Informatik3/02_UML/02_UML_Klassendiagramm
30_Informatik3/02_UML/02_UML_Klassendiagramm
30_Informatik3/02_UML/02_UML_Klassendiagramm

#aint
30_Informatik3/02_UML/03_Konstruktor
30_Informatik3/02_UML/03_Konstruktor
30_Informatik3/02_UML/03_Konstruktor

#aint
30_Informatik3/19_UML_ALT/02_UML_Flaechenberechnung
30_Informatik3/19_UML_ALT/02_UML_Flaechenberechnung
30_Informatik3/19_UML_ALT/02_UML_Flaechenberechnung

#aint
30_Informatik3/19_UML_ALT/04_ListeUML
30_Informatik3/19_UML_ALT/04_ListeUML
30_Informatik3/19_UML_ALT/04_ListeUML

#aint
30_Informatik3/02_UML/04_Statische_Variable
30_Informatik3/02_UML/04_Statische_Variable
30_Informatik3/02_UML/04_Statische_Variable

#aint
30_Informatik3/03_Strings/02_stringUML
30_Informatik3/03_Strings/02_stringUML
30_Informatik3/03_Strings/02_stringUML

#aint
30_Informatik3/06_Vererbung/01_MesswerteUML
30_Informatik3/06_Vererbung/01_MesswerteUML
30_Informatik3/06_Vererbung/01_MesswerteUML

#aint
30_Informatik3/06_Vererbung/03_VererbungsProgramm
30_Informatik3/06_Vererbung/03_VererbungsProgramm
30_Informatik3/06_Vererbung/03_VererbungsProgramm

#h5
NACHTRAG: Der Modifikator "protected" in C++:

#aint
30_Informatik3/07_Modifikatoren/02_protected_Vererbung
30_Informatik3/07_Modifikatoren/02_protected_Vererbung
"protected" in C++: 30_Informatik3/07_Modifikatoren/02_protected_Vererbung

#h4
2. Schnittstellen / Interfaces am Beispiel eines Simulationsprogramms

#br

#aint
73_COACH3/09_Algorithmen
73_COACH3/09_Algorithmen
73_COACH3/09_Algorithmen -- Spezielle Implementierungen von Modell und Integrator gengen deren allgemeinerer Spezifikation durch Interfaces.

#br

#aint
73_COACH3/09_Algorithmen/01_RungeKutta
73_COACH3/09_Algorithmen/01_RungeKutta
73_COACH3/09_Algorithmen/01_RungeKutta -- Prozedurale Umsetzung als Vorstufe zum Verstndnis.

#br

#aint
73_COACH3/09_Algorithmen/02_Loesungsansatz
73_COACH3/09_Algorithmen/02_Loesungsansatz
73_COACH3/09_Algorithmen/02_Loesungsansatz -- Ansatz in Java auf der Grundlage von Vererbung.

#br

#aint
78_Processing/06_Snippets/15_Simulation
78_Processing/06_Snippets/15_Simulation
78_Processing/06_Snippets/15_Simulation -- Beispielimplementierung mit Runge Kutta Integrator mit Processing.

#h5
Nachfolgendes Projekt wird ausfhrlich im Unterricht besprochen und bildet die Grundlage fr alle weiteren OOP-Projekte:

#zip
Simulator002.zip
Simulator002.zip -- Vollstndiges Simulationsprogramm, implementiert mit Processing unter Verwendung von Interfaces.

#h5
Ergnzung: Interfaces mit C++

#aext
https://stackoverflow.com/questions/318064/how-do-you-declare-an-interface-in-c
https://stackoverflow.com/questions/318064/how-do-you-declare-an-interface-in-c
Interfaces mit C++, Beispiel: https://stackoverflow.com/questions/318064/how-do-you-declare-an-interface-in-c

#h5
BUNG

#h5
Aufgabe 1

#ul
Erweitern Sie das Projekt Simulator002 um einen Eulerintegrator, der wie der Runge-Kutta-Integrator auch die iIntegrator-Schnittstelle verwendet.
Testen Sie das erweiterte Simulationsprogramm, indem statt des Runge-Kutta-Integrators der Euler-Integrator verwendet wird.

#zip
Simulator005_Euler.zip
Simulator005_Euler.zip -- studentische Lsung.


#h5
Aufgabe 2

#p
Unter nachfolgendem Link unter "Musterlsung zu bung 2 vom 15.12.2020" finden Sie eine
vollstndige Herleitung zum invertierenden Pendel und eine Umsetzung mit Scilab:

#aint
62_Regelungssysteme/98_day_by_day_WS2021_SoSe21
62_Regelungssysteme/98_day_by_day_WS2021_SoSe21
62_Regelungssysteme/98_day_by_day_WS2021_SoSe21 -- "Musterlsung zu bung 2 vom 15.12.2020"

#ul
Testen Sie die Simulation bei "Code 0-9: Scilab-Skript zur Bestimmung eines Zustandsreglers durch Polvorgabe und Simulation des nicht linearen Systems unter Verwendung dieses Reglers.".
bertragen Sie das Modell mit Zustandsregler und dessen Simulation auf eine Kopie des Projekts "Simulator002" mit dem Namen "Simulator004_Pendel" und testen es.


#h4
3. Planung der objektorientierten Implementierung eines Fuzzy-Reglers 

#p
Im Hinblick darauf, einen Fuzzy-Regler fr das invertierende Pendel auf der Basis von Processing zu entwerfen und zu optimieren,
soll folgende Vorarbeit geleistet werden:

#ol
Analyse einer einfachen prozeduralen Implementierung
Planung der Schnittstellen und Klassen
Implementierung der einzelnen Klassen (bungsaufgabe)
Testphase / berarbeitungen

#box
Nachfolgende Punkt vorr. in nachfolgenden Lehrveranstaltungen:

#h4
4. Vergleich: Objektorientierte Programmierung mit Java und C/C++

#aint
30_Informatik3/01_Vom_struct_zur_Klasse/03_Klassen_Programm
30_Informatik3/01_Vom_struct_zur_Klasse/03_Klassen_Programm
C++: 30_Informatik3/01_Vom_struct_zur_Klasse/03_Klassen_Programm

#h4
5. Einfhrung in Android-Processing

#aint
93_Android_Proc
93_Android_Proc
93_Android_Proc

#aint
77_Android
77_Android
77_Android

#h4
6. Einrichtung eines Hotspots unter Linux und unter Android, oder mittels eines Routers

#aint
92_Soundinstallation/03_material/11_Snippets/11_UDP
92_Soundinstallation/03_material/11_Snippets/11_UDP
Vernetzung mehrerer Gerte: 92_Soundinstallation/03_material/11_Snippets/11_UDP

#h4
Hotspot Android Device

#aint
05_esp32AV/01_Bauanleitung/01_Elektronik_und_Software/03_Videostream
05_esp32AV/01_Bauanleitung/01_Elektronik_und_Software/03_Videostream
05_esp32AV/01_Bauanleitung/01_Elektronik_und_Software/03_Videostream


#h4
Hotspot Linux Computer

#aint
08_Archiv/06_Ing/01_Bauplan/04_Hotspot
08_Archiv/06_Ing/01_Bauplan/04_Hotspot
08_Archiv/06_Ing/01_Bauplan/04_Hotspot

#h4
W-LAN-Router

#aint
05_esp32AV/01_Bauanleitung/03_FAQs
05_esp32AV/01_Bauanleitung/03_FAQs
siehe ganz unten!: Einrichtung am Beispiel von tp-link-W-LAN-Routern:  05_esp32AV/01_Bauanleitung/03_FAQs



#h4
7. Programmierung von Anwendungen mit UDP

#aint
67_Echtzeitsysteme/09_Internetprogrammierung/04_Java
67_Echtzeitsysteme/09_Internetprogrammierung/04_Java
Internetprogrammierung -- 67_Echtzeitsysteme/09_Internetprogrammierung/04_Java


#h1
SRT am Montag den 25.11.2025 -- Fortsetzung OOP / Einachser Simulation / Optimierung / Fuzzy-Regler

#h4
Themen

#ol
Hinweise zu OOP
Plotter-Klasse
Implementierung Einachser-Modell
Regler als Extraklasse
Regleroptimierung mittels Gradientenverfahren
Gemeinsamer Entwurf eines Fuzzy-Reglers

#h4
1. Hinweise zu OOP -- siehe Projekt Simulator002.zip

#ul
Polymorphismus: Siehe Helper-Methoden minimum() und maximum()
Ohne Allokation von Speicher haben Arrays das null-Objekt, siehe yt, y, t
Verwendung des Attributs length bei Arrays
Einfache Datentypen und Wrapper Classes / Double.MAX_VALUE / Character.isWhitespace()
Referenz zur Standard-Klasse String
Sichtbarkeit, vergl. Objekt plotter der Plotter-Klasse weiter unten.

#h4
2. Plotter-Klasse

#zip
Simulator006_Plotter.zip
Simulator006_Plotter.zip -- Plotfunktion in einer Klasse abbilden.

#h5
BUNG

#ul
Sorgen Sie in einer Variante von Simulator006_Plotter dafr, ...

#ul
... dass der lineare Schwinger sowohl mit Euler, als auch mit Runge-Kutta integriert wird. Erzeugen Sie dazu zwei verschiedene Simulator-Objekte.
... dass beide Simulationen als Plot mit jeweils verschiedenen Kurvenfarben dargestellt werden. Erzeugen Sie dazu zwei verschiedene Plotter-Objekte.

#h4
3. Implementierung Einachser-Modell

#zip
Simulator007_Einachser.zip
Simulator007_Einachser.zip

#aint
62_Regelungssysteme/98_day_by_day_WS2021_SoSe21
62_Regelungssysteme/98_day_by_day_WS2021_SoSe21
Grundlage bildet: 62_Regelungssysteme/98_day_by_day_WS2021_SoSe21, siehe dort "Musterlsung zu bung 2 vom 15.12.2020"


#h4
4. Regler als Extraklasse

#zip
Simulator008_Regler.zip
Simulator008_Regler.zip -- Vereinbarung einer Schnittstelle fr einen Regler / Umsetzung des Zustandsreglers

#h4
5. Regleroptimierung mittels Gradientenverfahren

#ol
Vereinbarung einer Fehlerfunktion
Umsetzung des Gradientenverfahrens

#zip
Simulator009_Fehlerfunktion.zip
Simulator009_Fehlerfunktion.zip -- Fehlerfunktuion fr den Zustandsregler des Einachsers.

#h5
BUNG

#code
public interface iOptimierer
{
     public abstract void configure(iFehlerfunktion fehlerfunktion, double[] startparameter);
     
     public abstract void iteration();
     
     public abstract double[] getBestParametersatz();
}
Interface fr einen Optimierer

#ul
Nehmen Sie obiges Interface fr eine Optimierer als Ausgangspunkt, um ein modifiziertes Gradientenverfahren fr den Einachser in Processing objektorientiert zu implementieren.
Testen Sie das Verfahren und simulieren und visualisieren Sie insbesondere vergleichsweise das System einmal mit den Startparametern und einmal mit den optimierten.

#h4
6. Gemeinsamer Entwurf eines Fuzzy-Reglers

#ol
Herstellen von Zufallswerten mit Java
Begrenzung der Antriebskraft!
Klrung: Wie knnen die verbalen Formulierungen programmiertecnisch umgesetzt werden?
Klrung: Wie knnen die Fuzzy-Regeln programmiertechnisch umgesetzt werden?
Gemeinsamer Entwurf des Softwarekonzepts.
Implementierung der Schnittstellen fr den Fuzzy-Regler.
Implementierung eines Fuzzy-Reglers fr den Einachser.
Optimierung des Fuzzy-Reglers mit Hilfe des modifizierten Gradientenverfahrens.


#h5
BUNG

#ul
Setzen Sie das Projekt vollstndig um.

#code
public void setup() 
{
}

public interface iEingangsFuzzySet
{
    /**
         breite ist der Abstand zwischen der am weitesten links liegenden Fuzzy-Gre und
         der am weitesten rechts liegenden.
         Alle Fuzzy-Gren werden quidistant angeordnet.
    */
    public abstract void setzeStuetzpunkte(double breite); 
    /** Liefert Erflltheitsgrad einer bestimmten Fuzzy-Gre */
    public abstract double berechneErfuelltheitsgrad(int index, double x);    
}

public interface iAusgangsFuzzySet
{
    /** breite reicht hier bis an die Berhrpunkte der ueren Dreiecke mit der x-Achse */ 
    public abstract void setzeStuetzpunkte(double breite); 
    /**
        int[][] regeln: jede Eingangsgre der beiden E.-Fuzzysets mit jeder kombiniert beeinflusst 
        eine Fuzzy-Gre des Ausgangsfuzzysets. Letztere ist im Array eingetragen als Index.
        double[][] aktivierungen: aktuell aus der Eingangssituation resultierende Aktivierungen jeder
        Regel korrespondierend mit int[][] regeln.
    */
    public abstract double berechneSchwerpunkt(int[][] regeln, double[][] aktivierungen); 
     
}

public interface iFuzzySystem
{
     public abstract double berechneAusgang(double[] y);
     /** obere neue Breiten fr Eingangsfuzzysets, unterste ist die Breite fr das Ausgangsfuzzyset */
     public abstract void setzeBreiten(double[] breiten);
}
Definition der Schnittstellen fr ein Fuzzy-System, das in Processing umgesetzt werden soll.

#h1
SRT am Montag den 01.12.2025 

#ol
Einfhrung in die Optimierung
Wie kann man das machen? -- Snippets und Hilfsfunktionen zur Bewltigung der Programmieraufgaben
Fortsetzung der bungsaufgaben, im Anschluss Arbeiten an den Projekten

#h4
1. Einfhrung in die Optimierung

#aint
50_Simulationstechnik/06_Optimierung
50_Simulationstechnik/06_Optimierung
Optimierung, Einfhrung -- 50_Simulationstechnik/06_Optimierung

#aint
50_Simulationstechnik/06_Optimierung/02_Heuristiken
50_Simulationstechnik/06_Optimierung/02_Heuristiken
Heuristiken -- 50_Simulationstechnik/06_Optimierung/02_Heuristiken

#aint
50_Simulationstechnik/06_Optimierung/01_Gradientenverfahren
50_Simulationstechnik/06_Optimierung/01_Gradientenverfahren
Gradientenverfahren -- 50_Simulationstechnik/06_Optimierung/01_Gradientenverfahren

#aint
50_Simulationstechnik/06_Optimierung/03_ModifizierteG
50_Simulationstechnik/06_Optimierung/03_ModifizierteG
Modifiziertes Gradientenverfahren -- 50_Simulationstechnik/06_Optimierung/03_ModifizierteG

#aint
50_Simulationstechnik/06_Optimierung/04_optim
50_Simulationstechnik/06_Optimierung/04_optim
optim() in Scilab -- 50_Simulationstechnik/06_Optimierung/04_optim

#code
function F = fehlerfunktion(u)
   x = u(1);
   y = u(2);
   F = x^3-4*x+y^3-16*y
endfunction

ustart = [1,1];
uopt   = [2/sqrt(3),4/sqrt(3) ]

Fstart = fehlerfunktion(ustart)
Fopt = fehlerfunktion(uopt)

alfa = 0.01;
schritte = 1000
u=ustart;
Fakt=fehlerfunktion(u)
for i=1:schritte
   r = floor(grand(2, 1, "unf", 0, 2.999999999))-1;
   uneu = u + alfa*(r');
   Fneu = fehlerfunktion(uneu);
   if Fneu<Fakt
      Fakt = Fneu;
      u=uneu;
   end
end

disp("Endergebnis der Optimierung:")
disp(u)
disp("Fehler am Ende:")
disp(fehlerfunktion(u))
Modifiziertes Gradientenverfahren mit Scilab.

#code
//Alfa steuern
function F = fehlerfunktion(u)
   x = u(1);
   y = u(2);
   F = x^3-4*x+y^3-16*y
endfunction

ustart = [1,1];
uopt   = [2/sqrt(3),4/sqrt(3) ]

Fstart = fehlerfunktion(ustart)
Fopt = fehlerfunktion(uopt)

alfa = 0.1;
alfaunterschwelle=0.003;
schritte = 100
u=ustart;
Fakt=fehlerfunktion(u)
//for i=1:schritte
while alfa>alfaunterschwelle
   r = floor(grand(2, 1, "unf", 0, 2.999999999))-1;
   uneu = u + alfa*(r');
   Fneu = fehlerfunktion(uneu);
   if Fneu<=Fakt //wenn sich nichts ndert, trotzdem wandern!!!
      Fakt = Fneu;
      u=uneu;
      alfa=alfa*1.1;
   else
      alfa=alfa*0.9;
   end
end

disp("Endergebnis der Optimierung:")
disp(u)
disp("Fehler am Ende:")
disp(fehlerfunktion(u))
disp("Alfa am Ende:")
disp(alfa);
Modifiziertes Gradientenverfahren mit Schrittweitensteuerung.

#h4
2. Wie kann man das machen? -- Snippets und Hilfsfunktionen zur Bewltigung der Programmieraufgaben

#p
Vorschlge:

#ul
private double berechneSteigung(double breite, int anzahlFuzzygroessen)
private double getZugehoerigkeitswert(double x, double breite, int anzahlFuzzygroessen, int indexFuzzygroesse)
...

#h4
3. Fortsetzung der bungsaufgaben, im Anschluss Arbeiten an den Projekten

#zip
Simulator010_Optimierer.zip
Simulator010_Optimierer.zip

#zip
Simulator011_Optimierer.zip
Simulator011_Optimierer.zip

#h5
BUNG

#ol
Bauen Sie eine Steuerung fr alfa in den Optimierer von Projekt Simulator011_Optimierer ein.
Fhren Sie nach der optimierung Simulationslufe mit den optimierten und den ursprnglichen Parametern durch und plotten beide.

#zip
Simulator012_Optimierer.zip
Simulator012_Optimierer.zip

#h5
BUNG

#zip
FuzzySystem001.zip
FuzzySystem001.zip

#ul
Vervollstndigen und Testen Sie die Klasse EingangsFuzzySet im Projekt FuzzySystem001.

#zip
FuzzySystem002.zip
FuzzySystem002.zip -- Musterlsung.


#h1
SRT am Dienstag den 02.12.2025 

#h4
Themen:

#ol
Fortsetzung zur Entwicklung eines Fuzzy-Systems mit Processing
Vorbesprechung der bungen
BUNGEN

#h4
1. Fortsetzung zur Entwicklung eines Fuzzy-Systems mit Processing

#zip
FuzzySystem003.zip
FuzzySystem003.zip -- Vollstndige aber nicht getestete Implementierung

#h4
2. Vorbesprechung der bungen

#h5
3. BUNGEN

#h5
Aufgabe 1 -- Wdh. Kleinste Quadrate Methode

#code
VoltCm = [ 2.5 20
           2.0 30
           1.5 40
           1.05 60
           0.75 90
           0.5  130
           0.45 150
         ];

// Aufgabe:
// a) Messwerte mglichst gut durch quadratische Funktion annhern
// b) Messwerte mglichst gut durch kubische Funktion annhern
// Verlufe aus a) , b) und den Messwerten bereinander als Plot darstellen

// a) und b) sind mit Scilab mittels kleinster Quadrate-Methode zu lsen.


Nherung der Mewerte zu einem Entfernungssensor ber Funktionen

#aext
https://www.sparkfun.com/datasheets/Sensors/Infrared/gp2y0a02yk_e.pdf
https://www.sparkfun.com/datasheets/Sensors/Infrared/gp2y0a02yk_e.pdf
Quelle / Datenblatt des Sensors: https://www.sparkfun.com/datasheets/Sensors/Infrared/gp2y0a02yk_e.pdf

#h5
Aufgabe 2 -- Parameterstudie

#ul
Nehmen Sie sich die Scilab-Umsetzung zur Simulation eines Zustandsgeregelten Invertierenden Pendels vor.
Ergnzen Sie in dem Scilab-Script eine Parameterstudie zum Auffinden guter Werte zur Regelmatrix R.
bertragen Sie Ihre Lsung in das Java-Processing-Projekt Simulator009, das bereits die notwendige Fehlerfunktion besitzt. 

#aint
62_Regelungssysteme/98_day_by_day_WS2021_SoSe21
62_Regelungssysteme/98_day_by_day_WS2021_SoSe21
Grundlage bildet wieder: 62_Regelungssysteme/98_day_by_day_WS2021_SoSe21, siehe dort "Musterlsung zu bung 2 vom 15.12.2020"

#h5
Aufgabe 3 -- Vorstudie Evolutionre Algorithmen

#ul
Rorschachbilder entstehen durch Aufbringen von Farbe auf ein Stck Papier und anschlieendem Zusammenfalten und Auseinanderklappen.
Dabei entsteht ein Bild, das typischerweise ausmehreren grtenteils zusammenhngenden spiegelsymmetrischen Figuren besteht.

#ul
Es sollen Rorschachbilder aus einem Optimierungsprozess heraus gebildet werden.
Pixelbilder mit zunchst gleichverteilten Pixeln sollen gleichzeitig die "Gene" und die Phnotypen sein.
Durch genetische Optimierung sollen sich nach und nach Bilder herauskristallisieren, die immer mehr Rorschachbildern hneln.

#ol
berlegen Sie sich, wie man die "Rohrschachartigkeit" quantifizieren kann.
Entwickeln Sie aus Ihren berlegungen heraus eine Fehlerfunktion, die die Grundlage des Optimierungsprozesses bilden knnte.
Testen Sie Ihre Funktion an mehreren Zufallsbildern, aber auch an einem von Ihnen selbst erstellten Pixelbild, das ein Rorschachbild sein knnte.
Nutzen Sie nachfolgendes Programm als Ausgangspunkt, um Ihre Bilder erzeugen und darstellen zu knnen.
Der zugehrige Evolutionre Prozess soll im Unterricht entwickelt werden. Sie knnen damit aber schon beginnen.

#code
import java.util.Random;

Random zufall = new Random(System.currentTimeMillis());

public int[][] erzeugeZufallsmatrix(int zeilen, int spalten)
{
    int[][] arr = new int[zeilen][spalten];
    
    for(int i=0;i<arr.length;i++)
       for(int k=0;k<arr[i].length;k++)
          arr[i][k] = zufall.nextInt(2);
    return arr;      
}

public void showArray(int[][] arr)
{
    println();
    for(int i=0;i<arr.length;i++)
    {
       for(int k=0;k<arr[i].length;k++)
       {
          print(arr[i][k]+" ");
       }   
       println();
    }      
}

public void drawArray(int[][] arr, float x, float y, float w)
{
    float d = w/(float)arr.length;
    noStroke();
    for(int i=0;i<arr.length;i++)
    {
       for(int k=0;k<arr[i].length;k++)
       {
           if(arr[i][k]>0)
              fill(0);
           else
              fill(255);
           rect(x+(float)k*d,y+(float)i*d,w,w);   
       }   
    }      
}

public void setup()
{
    size(600,600);
    frameRate(5);
    
    int[][] x = erzeugeZufallsmatrix(8, 8);
    showArray(x);
}

public void draw()
{
    background(255);
    int[][] x = erzeugeZufallsmatrix(16, 16);
    drawArray(x, 0, 0, width);
}
Hilfsprogramm.

#h5
Aufgabe 4 -- Verifizierung der FuzzySystem-Software FuzzySystem003

#ul
Erzeugen Sie im setup von FuzzySystem003 folgendes Fuzzy-System:

#code

1. Eingangsfuzzyset:
3 Fuzzygren
Breite: 2.0

2. Eingangsfuzzyset:
3 Fuzzygren
Breite: 2.0

Ausgangsfuzzyset:
3 Fuzzygren
Breite: 4.0

Regelmatrix:
0 1 2 
1 2 0
2 0 1
Zu erzeugendes Fuzzy-System

#ol
Bestimmen Sie den Ausgang des Systems zunchst von Hand fr folgende Stichprobenwerte:

#code

in1=1 in2=0 
in1=1 in2=1 
in1=0.5 in2=0.5 
in1=0.75 in2=1.0 

Stichproben.

#ol
berprfen Sie dann, ob sich diese Werte mit FuzzySystem003 reproduzieren lassen.
Korrigieren Sie ntigenfalls FuzzySystem003.

#h5
Aufgabe 5 -- Fuzzy-Regler fr das invertierende Pendel

#ul
Entwickeln Sie als Vorarbeit einen sinnvollen Regelsatz fr einen Fuzzy-Regler, der beim invertierenden Pendel eingesetzt werden knnte.
Legen Sie dazu auch fest, wieviele Fuzzy-Gren in den Fuzzysets vorkommen sollen und wie die Breiten der Bereiche der Fuzzysets bemessen werden sollten.

#p
Die Ergenisse dieser Aufgaben werden im nachgang diskutiert werden und dann umgesetzt.

#h1
SRT am Montag den 08.12.2025 -- Fortsetzung OOP / Einachser Simulation / Optimierung / Fuzzy-Regler

#h4
Themen

#ol
OOP mit Java
Besprechung zu Aufgabe 4 -- Verifizierung der FuzzySystem-Software FuzzySystem003
Implmementierung eines Fuzzy-Reglers fr den Einachser (9.12.)
Optimierung des Fuzzy-Reglers fr den Einachser (9.12.)

#h4
1. OOP mit Java

#ol
Die Main-Klasse bei Java -- Untersuchung eines regulren Java-Anwendungsprogramms
Vererbung mit Java 
Das Singleton-Pattern und seine Realisierung als statische Klasse in Java und in C++ bei der Mikrocontroller-Programmierung
jar und javadoc

#h5
Die Main-Klasse bei Java -- Untersuchung eines regulren Java-Anwendungsprogramms

#aint
36_Java
36_Java
36_Java

#aint
36_Java/01_GettingStarted
36_Java/01_GettingStarted
36_Java/01_GettingStarted -- Siehe Code 0-1.

#zip
java_konsolen_projekt.zip
java_konsolen_projekt.zip -- Java-Anwendung in Terminal kompilieren und starten.

#ul
Ein einfacher Processing-Sketch mit Klassen wird exportiert und dann untersucht.

#zip
Hallo001.zip
Hallo001.zip -- Exportierter Sketch.


#h5
Vererbung mit Java 

#zip
Hallo002.zip
Hallo002.zip -- Vektor als innere Klasse.

#zip
Hallo003.zip
Hallo003.zip -- Nebenlufiger Prozess mittels Schnittstelle (interface)

#ul
Erweitern der Fhigkeiten der Objekte einer Klasse mittels Vererbung

#h5
Das Singleton-Pattern und seine Realisierung als statische Klasse in Java und in C++ bei der Mikrocontroller-Programmierung

#aint
40_Mikrocontroller/08_OOP/03_Statisch
40_Mikrocontroller/08_OOP/03_Statisch
40_Mikrocontroller/08_OOP/03_Statisch -- Statische Methoden mit C++ bei der Mikrocontroller-Programmierung.

#h5
jar und javadoc

#p
Das Erzeugen und Einbinden von Java-Bibliotheken (.jar-Files), aber auch die automatische Erstellung 
von Dokumentationen mit Hilfe von javadoc wird beispielsweise in der Entwicklungsumgebung bluej direkt untersttzt, siehe beispielsweise:

#aint
93_Android_Proc/02_Eigene_Library
93_Android_Proc/02_Eigene_Library
93_Android_Proc/02_Eigene_Library

#aint
93_Android_Proc/03_Crossplattform
93_Android_Proc/03_Crossplattform
93_Android_Proc/03_Crossplattform

#h4
2. Besprechung zu Aufgabe 4 -- Verifizierung der FuzzySystem-Software FuzzySystem003

#ul
Siehe erneut "Bild 4-4: Fuzzy-System" weiter oben.
Musterlsung fr die geforderten Werte:

#code
    p= 0.5 
    q= 0.0
    r= 4.0
    s= 0.0
    t= 0.5
    u= 5.0
    v= 0.5
    w= 0.5
    x= 4.5
Musterlsung fr die geforderten Werte.

#ul
Leider lsst sich die bung nicht beim aktuellen Stand der Entwicklung bertragen, jedoch durch eine kleine Ergnzung:
Durch Angabe eines immer zu verwendenden Offsets OFFSET bei den Eingangssignalen, der dann abgezogen werden muss vor der Auswertung und
...durch Angabe eines Offsets OFFSET fr das Ausgangs-Fuzzysets, der hinzugezhlt wird.
Beides kann durch Ergnzung weiterer Konstruktoren erfolgen.
Desweiteren muss die Mglichkeit gegeben werden, Regeln auszulassen. Nachfolgend realisiert durch Angabe des Index -1 in der Matrix regel.
Schlielich wurde noch die Mglichkeit ergnzt, die Aktivierung einzelner Regeln abzurufen.
Vergl. nachfolgende Musterlsung.

#zip
FuzzySystem004.zip
FuzzySystem004.zip -- Musterlsung.

#code
public void setup() 
{
   double[] OFFSETS = {3.0,3.0,4.5};
   double[] breiten = {2.0,2.0,3.0};
   int[] anzahlFuzzyGroessen = {3,3,2};     
   int[][] regeln = {
                        {-1,-1, 0}, //  -1 => fehlende Regel!
                        {-1, 1,-1},
                        {-1,-1,-1}
                    };
   //FuzzySystem(double[] OFFSETS, double[] breiten, int[] anzahlFuzzyGroessen, int[][] regeln)
   FuzzySystem fs = new FuzzySystem(OFFSETS,breiten,anzahlFuzzyGroessen,regeln);
   
   println("p="+fs.berechneAktivierung(new double[] {2.5,4.0}, 0, 2));
   println("q="+fs.berechneAktivierung(new double[] {2.5,4.0}, 1, 1));
   println("r="+fs.berechneAusgang(new double[] {2.5,4.0}));
   
   println("s="+fs.berechneAktivierung(new double[] {3.5,2.5}, 0, 2));
   println("t="+fs.berechneAktivierung(new double[] {3.5,2.5}, 1, 1));
   println("u="+fs.berechneAusgang(new double[] {3.5,2.5}));
   
   println("v="+fs.berechneAktivierung(new double[] {2.5,3.5}, 0, 2));
   println("w="+fs.berechneAktivierung(new double[] {2.5,3.5}, 1, 1));
   println("x="+fs.berechneAusgang(new double[] {2.5,3.5}));
}  
setup-Methode der Musterlsung.

#h1
SRT am Montag den 09.12.2025 -- Fortsetzung OOP / Einachser Simulation / Optimierung / Fuzzy-Regler

#h4
Themen

#ol
Implmementierung eines Fuzzy-Reglers fr den Einachser 
Optimierung des Fuzzy-Reglers fr den Einachser 
Fehlerfunktion fr das Rorschachproblem
Evolutionrer Optimierer fr das Rorschachproblem

#h4
1. Implmementierung eines Fuzzy-Reglers fr den Einachser 

#h4
2. Optimierung des Fuzzy-Reglers fr den Einachser 

#zip
Simulator013_Fuzzy.zip
Simulator013_Fuzzy.zip -- Musterlsung.

#p
Ersetzt werden musste:

#ol
Der verwendete Regler
Die verwendete Fehlerfunktion

#p
Das vorbereitete Fuzzy-System wird Teil des Reglers.

#code
public class FuzzyRegler implements iRegler
{
  double FMAX = 0.0;
  
     FuzzySystem fs;
  
     public FuzzyRegler()
     {
          //FuzzySystem(double[] breiten, int[] anzahlFuzzyGroessen, int[][] regeln)
          double[] breiten = {1.0,1.0,1.0};
          int[] anzahlFuzzyGroessen = {5,5,5};
          // -- - 0 + ++
          //  0 1 2 3 4
          int[][] regeln = {
              { 4, 4, 3,-1,-1},
              { 4, 3, 3,-1,-1},
              {-1, 3, 2, 1,-1},
              {-1,-1, 1, 1, 0},
              {-1,-1, 1, 0, 0}            
          };
          fs = new FuzzySystem(breiten, anzahlFuzzyGroessen, regeln);
     }
  
     public double berechneStellgroesseU(double[] y)
     {
        double phi = y[0];
        double om  = y[1];
        //double FA = -R[0]*phi - R[1]*om;
        double FA = fs.berechneAusgang(y);
        
        if(FA<FMAX)
        {
             FMAX=FA;
             //println("FA="+FA);
        }
        
        
        if(FA>0.4) FA=0.4;
        if(FA<-0.4) FA=-0.4;
        
        return FA;
     }
     public void setParameter(double[] param)
     {
         fs.setzeBreiten(param);
     }
}
Implementierung des Fuzzy-Reglers.

#code
public class FehlerfunktionFuzzyregler implements iFehlerfunktion
{  
     Simulator simulator;
     iRegler regler;
     double[][] yt; //letzte Zeile: t Verlauf
     double dt;
     public FehlerfunktionFuzzyregler()
     {
         regler = new FuzzyRegler();
         simulator = new Simulator(new RungeKuttaIntegrator(),new Einachser(regler));
         dt = 20.0/3000.0; // 20 Sekunden, 3000 Schritte
         yt=simulator.exec(dt, 3000, 0.0, new double[] {10.0*Math.PI/180,0.0});
     }
  
     public double berechneFehler(double[] param)
     {
         regler.setParameter(param);
         yt=simulator.exec(dt, 3000, 0.0, new double[] {10.0*Math.PI/180,0.0});
         double errPHI = 0.0;
         double errOM = 0.0;
         for(int i=0;i<yt[0].length;i++)
             errPHI+=yt[0][i]*yt[0][i];
         errPHI = Math.sqrt(errPHI);    
         for(int i=0;i<yt[1].length;i++)
             errOM+=yt[1][i]*yt[1][i];
         errOM = Math.sqrt(errOM);
         return errPHI + errOM;
     }
}
Implementierung der Fehlerfunktion.


#h4
3. Fehlerfunktion fr das Rorschachproblem

#h4
4. Evolutionrer Optimierer fr das Rorschachproblem






!!!ENDE

