!!!KURZSCHRIFT
#hauptkapitel
Development of Fault Tolerant Software for Embedded Realtime Systems, winter semester 2025/26 

#box
Start of the course: 9:00 a.m.

#ul
Tasks for those who arrive early:
Download the course text and read it.
Learn how to log in to the PCs in the lab.
Take a look at processing.org and try out some examples on the PCs running Linux.

#ul
Aufgaben für alle, die früher da sind:
Laden Sie sich den Text beim Kurs herunter und lesen ihn.
Lernen Sie, wie Sie sich auf den PCs im Labor einloggen können.
Schauen Sie sich processing.org an und probieren Beispiele auf den PCs unter Linux aus.



#ul
student group: 1 ME

#ul
Here at "day by day," the content covered is noted chronologically over the course of the semester.
In most cases, links are provided within kramann.info where the respective material is presented.
For your reference, you will also find the "day by day" for the same course from the previous year on kramann.info.
The examination in this subject takes place throughout the semester and consists of a project that is presented at the end of the semester.

#h1
Wednesday, September 24, 2025

#h4
Topics today

#ol
Organizational matters
Why do malfunctions occur in Western technology in the first place -- an anthropological perspective
Introduction to the topic of fault tolerance
Introduction to the terms "fault," "error," and "failure"
Introduction to the term "mitigation"
Examples of "mitigation" in modern technology
Division into groups of two
Scheduling appointments for presentations on fault tolerance patterns
Practical application: Smart Watch
Discussion of possible areas in the Smart Watch where fault tolerance can play a role

#ol
Organisatorisches
Warum ergeben sich überhaupt Funktionsstörungen bei der abendländischen Technik -- eine anthropologische Betrachtung
Einführung in das Thema Fehlertoleranz
Einführung der Begriffe "fault", "error" und "failure"
Einführung des Begriffs "mitigation"
Beispiele für "mitigation" in der modernen Technik
Gruppenaufteilung in Zweiergruppen
Terminvereinbarungen für die Präsentationen der Fehlertoleranz Muster
Praktische Anwendung: Smart Watch
Diskussion zu möglichen Bereichen bei der Smart Watch, bei denen Fehlertoleranz eine Rolle spielen kann
Vorübungen mit Java/Processing
Einführung in die Entwicklungsumgebung von Processing

#h4
1. Organizational matters

#ul
The exam takes place throughout the semester and consists of a theoretical presentation, a project assignment, and the presentation of the project assignment at the end of the lecture period.
Students are to work in pairs.
A group list will be circulated for registration.
A fault tolerance pattern will be presented in the theoretical presentation.
In the project work, a smart watch will be programmed and at least two fault tolerance patterns will be applied during implementation.
In the first half of the semester, introductory projects will be carried out together with the smart watch and the basics will be worked out.
From the second half of the semester onwards, work on the projects will mainly take place independently in the groups.
Work on the projects will take place during regular class time.
The final project presentation must represent what has been developed during the semester as seen by the lecturer.
The project part of the exam counts for 80 percent, and the theoretical presentation of a pattern counts for 20 percent of the overall grade.

#ul
Die Prüfung ist semesterbegleitend und besteht aus einer theoretischen Präsentation, einer Projektarbeit und der Präsentation der Projektarbeit am Ende der Vorlesungszeit.
Es soll dazu in Zweiergruppen gearbeitet werden.
Eine Gruppenliste zum Eintragen wird herumgegeben.
In der theoretischen Präsentation wird ein Fehlertoleranz Muster vorgestellt.
In der Projektarbeit wird eine Smart Watch programmiert und mindestens zwei Fehlertoleranz Muster bei der Umsetzung angewendet.
In der ersten Semesterhälfte werden gemeinsam Einführungsprojekte mit der Smart Watch durchgeführt und die Grundlagen erarbeitet.
Ab der zweiten Semesterhälfte finden hauptsächlich die Arbeiten an den Projekten selbstständig in den Gruppen statt.
Die Arbeit an den Projekten erfolgt innerhalb der regulären Unterrichtszeit.
Die abschließende Projektpräsentation muss das repräsentieren, was für den Dozenten sichtbar während des Semesters erarbeitet wurde.
Der Projektteil der Prüfung zählt 80 Prozent, die theoretische Präsentation eines Pattern zählt 20 Prozent der Gesamtnote.

#h4
2. Why do malfunctions occur in Western technology in the first place -- an anthropological perspective

#p
I would like to help you understand what makes Western technology so special.
I would like to work with you to identify the strengths and, if they exist, the fundamental weaknesses of Western technology.
One way to do this is through comparison.
Technical anthropology is a science that compares technologies from different cultures.

#code
Heßler, M., Liggieri, K.: Technikanthropologie: Handbuch für Wissenschaft und Studium, Nomos, Baden-Baden 2020.
Literatur zu Technikanthropologie

#p
As an example, I will use ship navigation in the following.

#br

#aext
https://www.researchgate.net/publication/261594890_Polynesian_Navigation_and_Te_Lapa-_The_Flashing
https://www.researchgate.net/publication/261594890_Polynesian_Navigation_and_Te_Lapa-_The_Flashing
Marianne George (2012) Polynesian Navigation and Te Lapa -- "The Flashing", Time and Mind: The Journal of Archaeology, Consciousness and Culture, 5:2, 135-173, aufgerufen: 22.09.2025, url: https://www.researchgate.net/publication/261594890_Polynesian_Navigation_and_Te_Lapa-_The_Flashing

#br

#p
Example: Boatbuilding in Taumako, documentary film by Michael Tauchert.

#aext
http://mitropico.com/filter/Reihe-Magische-Welten-ZDF/Polynesien-Nomaden-der-Sudsee
http://mitropico.com/filter/Reihe-Magische-Welten-ZDF/Polynesien-Nomaden-der-Sudsee
mitropico.com/filter/Reihe-Magische-Welten-ZDF/Polynesien-Nomaden-der-Sudsee

#p
Visual documentation

#aext
http://vaka.org/
http://vaka.org/
vaka.org -- Taumako Projekt

#p
Navigation with Te Puke Booten -- Dr. Mimi George

#aext
https://www.vaka.org/blog/categories/navigation
https://www.vaka.org/blog/categories/navigation
https://www.vaka.org/blog/categories/navigation

#h5
ÜBUNG

#ul
Discuss the difference between Western technology, with which you are familiar, and the Polynesian art of boat building and navigation.
The Polynesian islands were colonized by various European countries until the 1950s. 
Consider the advantages and disadvantages of the different types of technology, as represented on the one hand by Polynesian navigation and boatbuilding and on the other by their Western counterparts today.
Living with technology: Consider the two types of technology in terms of everyday life. Categories such as happiness and satisfaction are rarely discussed in a technological context, but ultimately, the technologization of the world should have this as its goal. So what is the situation here?

#aext
https://www.researchgate.net/publication/222699397_Goal_Navigation_and_Island-Finding_in_Sea_Turtles
https://www.researchgate.net/publication/222699397_Goal_Navigation_and_Island-Finding_in_Sea_Turtles
Wave interference pattern caused by an island. Kenneth Lohmann und Graeme C Hays:  Goal Navigation and Island-Finding in Sea Turtles, Journal of Experimental Marine Biology and Ecology 356(1-2):83-95 DOI:10.1016/j.jembe.2007.12.017, url: https://www.researchgate.net/publication/222699397_Goal_Navigation_and_Island-Finding_in_Sea_Turtles

#aext
https://de.wikipedia.org/wiki/Polynesische_Navigation#Navigationstechniken
https://de.wikipedia.org/wiki/Polynesische_Navigation#Navigationstechniken
see also: https://de.wikipedia.org/wiki/Polynesische_Navigation#Navigationstechniken

#aext
https://de.wikipedia.org/wiki/John_Harrison_(Uhrmacher)
https://de.wikipedia.org/wiki/John_Harrison_(Uhrmacher)
Clock "H5" by John Harrison, ca. 1770: https://de.wikipedia.org/wiki/John_Harrison_(Uhrmacher)


#h4
3. Introduction to the topic of fault tolerance

#aint
81_FTSD/01_Fehlertoleranz
81_FTSD/01_Fehlertoleranz
81_FTSD/01_Fehlertoleranz

#h4
4. Introduction to the terms "fault," "error," and "failure"

#h5
Exercise

#ol
Describe the concepts of "fault", "error" and "failure".

#h4
5. Introduction to the term "mitigation"

#h4
6. Examples of "mitigation" in modern technology

#h5
Exercise

#ol
Group exercise: Find examples of where modern technology automatically mitigates the effects of errors that occur.

#h4
7. Division into groups of two

#h4
8. Scheduling appointments for presentations on fault tolerance patterns

#h4
9. Practical application: Smart Watch

#img
watch1.png
T-Watch 2020 V3 from Lilygo.


#ul
We will be working with a T-Watch 2020 V3.
This will be done within the Arduino development environment.

#p
These are peripherals that can be controlled by programming on the watch:

#ol
Display
Touch
IMU (Inertia Measurement Unit)
RTC (Real Time Clock)
WiFi
Bluetooth
Button
Vibration
Mikrophone
Loudspeaker

#aext
https://youtu.be/xQJAm8CVC_4
https://youtu.be/xQJAm8CVC_4
Programming examples: https://youtu.be/xQJAm8CVC_4

#aext
https://youtu.be/rJJumsD5vB8
https://youtu.be/rJJumsD5vB8
T-WATCH send Acceleration to Laptop via WiFi: https://youtu.be/rJJumsD5vB8

#br

#ul
So you have a whole list of components that only make sense as a whole when they are linked together in some way by software.
That is exactly what we will be dealing with: linking the internal peripherals of an embedded system together using software to form a useful whole.

#cite
Any sufficiently advanced technology is indistinguishable from magic
Arthur C. Clarke

#br

#p
...in diesem Sinne: 

#ol
How could a smartwatch help support your life on this campus?
Which of the internal peripherals listed above would be used in the application you have proposed?
Which externally available infrastructure would be used by your newly created system?
What disruptions could occur during the interaction of the smartwatch with its environment and the surrounding infrastructure?
What measures could be taken to minimize the impact of the identified potential disruptions? 

#p
Corresponding links, see:

#br

#aext
https://lilygo.cc/products/t-watch-2020-v3
https://lilygo.cc/products/t-watch-2020-v3
Purchase from Lilygo: https://lilygo.cc/products/t-watch-2020-v3

#br

#aext
https://github.com/Xinyuan-LilyGO/TTGO_TWatch_Library
https://github.com/Xinyuan-LilyGO/TTGO_TWatch_Library
TTGO_TWatch_Library V1.4.3: https://github.com/Xinyuan-LilyGO/TTGO_TWatch_Library

#br

#box
necessary: esp32 Board Library 2.09 (exactly this one!)


#h4
10. Discussion of possible areas in the Smart Watch where fault tolerance can play a role

#h1
Wednesday, September 30, 2025

#h4
Topics today

#ol
Quiz
Overview over fault tolerance pattern
Initial collection of ideas on possible applications for the clock and possible fault tolerance patterns that could be used in this context
Presentation: Hello World-program with T-WATCH
Preliminary exercises with Java/Processing
Introduction to the Processing development environment
Presentation: Starting with T-WATCH
Exercise: Hello World-program with T-WATCH


#h4
1. Quiz

#p
Define the terms "fault," "error," and "failure"

#h4
2. Initial collection of ideas on possible applications for the clock and possible fault tolerance patterns that could be used in this context

#code



DAILY LIFE

   step counter (IMU sensor)
   remote control for TV, radio etc. (infrared data transmitter)

   recognition of too intensive sun exposure (Light intensity sensor)

   using bluetooth to connect to the phone for passing messages

   doing calls using microphone and loudspeaker

   performing alarms by using vibration

   games with distributed users

SPORTS

   compass

MEDICINE

   Reminder for taking medicine / body sensoring ... measurement of level of insuline e.g.
   heart rate monitoring sensor

   rescue system (alarm if no motion)
   rescue system (alarm if to hard motion)

WORK CONTEXTS

Initial collection of ideas on possible applications for the clock and possible fault tolerance patterns that could be used in this context.

#h4
3. Overview: fault tolerance pattern

#aint
81_FTSD/01_Fehlertoleranz
81_FTSD/01_Fehlertoleranz
81_FTSD/01_Fehlertoleranz

#h4
4. Presentation: Hello World-program with T-WATCH

#h4
5. Preliminary exercises with Java/Processing

#aint
36_Java
36_Java
36_Java

#aint
78_Processing
78_Processing
78_Processing

#br

#aext
https://processing.org/
https://processing.org/
https://processing.org/

#br

#aint
74_EmbSyst/02_Eingebettete_Systeme/03_Android/06_Processing
74_EmbSyst/02_Eingebettete_Systeme/03_Android/06_Processing
74_EmbSyst/02_Eingebettete_Systeme/03_Android/06_Processing

#h4
6. Introduction to the Processing development environment

#p
...will be done on PCs.

#h4
7. Presentation: Starting with T-WATCH

#aint
07_TWATCH_EN
07_TWATCH_EN
07_TWATCH_EN -- english version.

#aint
06_TWATCH
06_TWATCH
06_TWATCH -- german version.

#h4
8. Exercise: Hello World-program with T-WATCH

#aint
07_TWATCH_EN/03_Hello_world
07_TWATCH_EN/03_Hello_world
Follow steps here: 07_TWATCH_EN/03_Hello_world.

#br
#br

#h1
Wednesday, October 07, 2025

#br

#h4
Topics today

#ol
Organization of presentation dates for fault tolerance patterns
Systematic introduction to programming the watch
Small programming tasks for using the screen, touchscreen, button, IMU sensor, and real-time clock.
Small project for an application program using the internal peripherals covered so far

#h4
1. Organization of presentation dates for fault tolerance patterns

#code

WEDNESDAY 15.10. 22.10. 29.10. 
          05.11. 12.11. 19,11,
          --------------------
          26.11. 03.12. 10.12.
          17.12.
Dates for the presentations.

#ul
Appointments according to the group list

#h4
2. Systematic introduction to programming the watch

#ol
Basic structure of a C/C++ program
Hello world program, processing in the console
Comparison of standard C programs with program structure for the clock
Declaration and initialization of variables
Variable types
Functions in C/C++
Transfer and return values for functions
Distinction between call by value and call by reference
Classes and objects in C++ and Java

#h5
Programs made during the course:

#code
#include <iostream>
using namespace std;
int main(void)
{
    cout<<endl<<"Hello world!"<<endl;
    return 0;
}
hello.cpp

#code
#include <iostream>
using namespace std;

int x=7; // declaration and initialization == definition
char y='4';
char text[]="My text."; // ends with 0 == '\0'
int main(void)
{
    cout<<endl<<"Hello world! "<<"x="<<x<<endl;
    cout<<(int)y<<endl;
    cout<<text<<endl;
    cout<<size(text)<<endl;
    return 0;
}
hello2.cpp (variables)

#code
#include <iostream>
using namespace std;

int mult(int x, int y)
{
   int z = x*y;
   return z;
}

int main(void)
{
    cout<<"4*5="<<mult(4,5)<<endl;
    return 0;
}
hello3.cpp

#code
#include <iostream>
using namespace std;

bool hasE(char text[])
{
   int index = 0;
text[0]='#';
   while(text[index]!='\0')
   {
       if(text[index]=='e' || text[index]=='E')
           return true;
       index++;
   }
   return false;
}

int main(void)
{
    char sentence1[] = "This is cool!";
    char sentence2[] = "This is an elephant!";

    cout<<sentence1<<" ..has an e?:"<<hasE(sentence1)<<endl;
    cout<<sentence2<<" ..has an e?:"<<hasE(sentence2)<<endl;
    cout<<sentence1<<endl;
    cout<<sentence2<<endl;

    return 0;
}
hello4.cpp (call by reference)

#code
#include <iostream>
#include <math.h>
using namespace std;
class Vektor
{
    public:
       double x,y;
   
       double calculateLength()
       {
           return sqrt(x*x+y*y);
       }
}; 
int main(void)
{
    Vektor v1,v2;
    v1.x=3.0;
    v1.y=4.0;
    v2.x=1.0;
    v2.y=0.0;
    double l1 = v1.calculateLength();
    double l2 = v2.calculateLength();
    cout<<"|v1|="<<l1<<endl;
    cout<<"|v2|="<<l2<<endl;
    return 0;
}
hello5.cpp (explain classes and objects in objectoriented programing)




#h4
3. Small programming tasks for using the screen, touchscreen, button, IMU sensor, and real-time clock.

#ul
The list of simplified commands has been expanded specifically for the internal peripheral elements listed here.
To complete the following tasks, refer to the descriptions and examples here:

#aint
07_TWATCH_EN/04_Simplified_Commands
07_TWATCH_EN/04_Simplified_Commands
07_TWATCH_EN/04_Simplified_Commands


#p
Exercise 1: Switsch Background color by pressing the button multiple times between
red, green, blue, red, green, blue, red, ... and so on.

#code
#include "twatch.h"
#include "variables.h"
#include "functions.h"
 int state=0;
void setup() 
{
    setupTWATCH();
    backlight(true); 
    
}

void loop() 
{
  
    if(button()) {
      state++;
      if(state > 2){
        state=0;
      }
      switch(state){
        case 0:
        background(255,0,0);
       break;
       case 1:
       background(0,255,0);
       break;
       case 2:
       background(0,0,255);
       break;
      }
    }
    
    
    delay(100);  
}
Student solution.

#p
Exercise 2: Program a type of water clock. 
The deviation of the clock from the horizontal position should be visualized 
graphically by moving a small circle on the display away from the center of the display.

#code
#include "twatch.h"
#include "variables.h"
#include "functions.h"

float skalierung=0.5;
float KreisX=0;
float KreisY=0;
void setup() 
{
    setupTWATCH();
    backlight(true); 
}

void loop() 
{
    bool res = acceleration();

  if(KreisX>240){
    KreisX=240;
  }else if(KreisX<0){
    KreisX=0;
  }else{
    KreisX = 120 - (float)(accY*skalierung);
  }
  if(KreisY>240){
    KreisY=240;
  }else if(KreisY<0){
    KreisY=0;
  }else{
    KreisY = 120 + (float)(accX*skalierung);
  }
  

 fill(0,0,255);
 circle(KreisX,KreisY,20);
    delay(50);
    clear();
    delay(50);
}
Student solution.

#p
Exercise 3: Program a type of stopwatch.
The stopwatch should be accurate to one-hundredth of a second.
To do this, analyze in project "TWATCH_PROC023" the "functions.h" tab to find out how to obtain the elapsed time in milliseconds.


#h4
4. Small project for an application program using the internal peripherals covered so far

#p
Implement the following project: A warning system should sound an alarm via the vibration motor and a suitable display if the watch is not held horizontally for more than 10 seconds.

#h1
Wednesday, October 15, 2025

#h4
Topics today

#ol
Besprechung zu nützlicher Literatur
Analyse der Projekte von letzter Woche
Hinweise zu Internetprogrammierung
Datenübertragung per W-LAN
Übertragung eines Processing-Sketches auf ein Mobile Device
ÜBUNG: Umsetzen eines ersten Fehlertoleranzkonzepts

#h4
1. Besprechung zu nützlicher Literatur

#p
Quelle für die Fehlertoleranzpattern ist das Buch von Hanmer:

#ul
Hanmer, R.S., "Pattern for Fault Tolerant Software", John Wiley & Sons, Weinheim 2007.

#p
Um die Programmierung eines esp32 zu verstehen, können entsprechende Programmierhandbücher benutzt werden:

#ul
Brandes, U., "Mikrocontroller ESP32", Rheinwerk, Bonn 2020.

#p
Ferner kann es sich lohnen, mehr über Processing zu erfahren, da sich die vereinfachte Programmierung der Uhr daran anlehnt:

#ul
Shiffman, D., "Learning Processing: A Beginner's Guide to Programming Images, Animation, and Interaction", Morgan Kaufmann, Burlington 2015.

#p
Wenn außerdem ein Smartphone als Gegenstelle verwendet werden soll lohnt sich folgendes Buch, bei dem auf Basis von Processing Android-Apps entwickelt werden:

#ul
Sauter, D., "Rapid Android Development", The Pragmatic Bookshelf, Dallas 2013.

#p
Bücher diesen Typs können hilfreich sein. Es müssen nicht unbedingt genau diese sein.
Nutzen Sie neben der Bibliothek der THB auch die TU-Bibliothek (Volkswagen Bibliothek) in Berlin, Nähe Omnibusbahnhof / Station Zoologischer Garten.

#h4
2. Analyse der Projekte von letzter Woche

#h4
3. Hinweise zu Internetprogrammierung

#h4
4. Datenübertragung per W-LAN und ein erstes Fehlertoleranzkonzept

#aext
https://youtu.be/rJJumsD5vB8
https://youtu.be/rJJumsD5vB8
T-WATCH send Acceleration to Laptop via WiFi: https://youtu.be/rJJumsD5vB8

#ul
Obiges Beispiel zeigt die besondere Verwendung der Smartwatch, bei der Beschleunigungsdaten der Uhr über W-LAN an einen PC gesendet werden.
Da hier zwei Geräte über Funk miteinander kommunizieren, kann dabei einiges schiefgehen.

#h5
ÜBUNG

#ul
Zählen Sie mögliche Fehlerquellen auf, die bei dem Versuch eine Datenverbindung per W-LAN zwischen Uhr und PC herzustellen auftreten können.


#h2
Konzept für das Herstellen der Datenverbindung über W-LAN

#ul
Das bekannte Projekt TWATCH_PROC023 besitzt die Fähigkeit per W-LAN Beschleunigungsdaten an einen PC zu schicken.
Sobald der Knopf gedrückt wird, wird geprüft, ob eine W-LAN Verbindung vorliegt und falls nicht, versucht, sie herzustellen:

#code
    if(button()) //wird ausgeführt, wenn Knopf gedrückt
    { 
        if(!WIFIOKAY) //Falls WIFi NICHT verfügbar
        {
            setupWIFI(hotspot,password,udpport); //...Verbindungsversuch starten
        }
        ....
     }
Haupttab von Projekt TWATCH_PROC023 ab Zeile 227.

#ul
Steht die WiFi Verbindung, so werden im MODE Nr. 2 bei der Uhr zyklisch die Beschleunigungsdaten an den PC gesendet:

#code
      case 2: //Acceleration (Switch Anweisung bei MODE 2)
      {
        backlight(true);
        cursor(0,0);
        bool res = acceleration();            //Auslesen der Beschleunigungswerte
        if(WIFIOKAY && udp.listen(UDPPORT))   //Wenn WiFi Verbindung vorhanden und ein Datenpaket vom PC empfangen wird...
        {
            udp.onPacket([](AsyncUDPPacket packet) 
            {
                if(Serial) Serial.write(packet.data(), packet.length());            
                if(Serial) Serial.println();
                packet.printf("accX=%d accY=%d accZ=%d", accX,accY,accZ);  //Übertrage die Beschleunigungsdaten          
            });      
        }
        ...
      }
      ...
Haupttab von Projekt TWATCH_PROC023 ab Zeile 110.

#ul
Im Kopf des Haupttabs müssen folgende wichtige Daten und Bibliotheken bereit gestellt werden:

#code
#include "twatch.h"
#include "variables.h"
#include "functions.h"

...

const char* hotspot = "hotspotX";
const char* password = "12345678";
int udpport = 6000;
...

Haupttab von Projekt TWATCH_PROC023 ab Zeile 1.

#ul
Im setup() wird die Uhr folgendermaßen konfiguriert:

#code
void setup() 
{
    setupTWATCH();
    setupSERIAL(115200);
    setupWIFI(hotspot,password,udpport); Bereits hier wird ein Verbindungsversuch gestartet
    setupMotor();
    //setFont(3);
    //setFont(2,255,55,0,  0,0,0);
    setFont(1, 255,255,255,  255,0,0);
    updateTime(); //RTC Zeit nehmen
    backlight(true); 
}
Haupttab von Projekt TWATCH_PROC023 ab Zeile 1.

#h2
PC seitiges Programm

#ul
PC-seitig wird ein Processing-Programm benutzt, um die WiFi-Verbindung mit der Uhr herzustellen.
Zudem muss ein Hotspot bereitgestellt werden bei dem beide Geräte angemeldet sein müssen.
ACHTUNG: Die PCs im PC-Pool sind nicht WiFi-fähig. Um Versuche durchführen zu können, können Smartphones oder Laptops verwendet werden.
 

#zip
TWATCH_PROC005_hotspot.zip
TWATCH_PROC005_hotspot.zip -- Processingsketch für den PC-seitigen Part.

#code
import hypermedia.net.*;
String IP = "10.42.0.255"; 
int PORT = 6000; //für UDP benötigt.
UDP udp;

String NACHRICHT="";

public void setup()
{
    size(700,500);
    udp = new UDP( this, 6000 );
    udp.listen( true ); 
    frameRate(10);
}

public void draw()
{
    background(255);
    fill(0);
    textSize(20);
    text("Empfangen:",30,30);
    text(NACHRICHT,30,60);     //Nachricht der Uhr ggf. anzeigen.
    
    udp.send("Test", IP, PORT );  //Zyklisch einen "PING" an die Uhr schicken.
}

   void receive( byte[] data, String ip, int port ) //Callback Funktion, die auf hereinkommende Pakete reagiert.
   {  
      // <-- extended handler  
      // get the "real" message =
      // forget the ";\n" at the end <-- !!! only for a communication with Pd !!!
      //data = subset(data, 0, data.length-2);
      String x = new String( data );
      if(x!=null && !x.equals("Test"))  //Nachricht der Uhr bereitstellen.
         NACHRICHT = x;
   }     
Processing Sketch für die PC / Laptop-Seite.

#h4
5. Übertragung eines Processing-Sketches auf ein Mobile Device


#h5
6. ÜBUNG: Umsetzen eines ersten Fehlertoleranzkonzepts

#h2
Aufgabe 1

#ul
In den vergangenen zwei Wochen wurden kleine Beispielprogramme zu verschiedenen internen Peripherien besprochen.
Schreiben Sie selber ein solches Beispielprogramm im Zusammenhang mit WiFi.
Es soll aus den weiter oben besprochenen Teilen aus dem Projekt TWATCH_PROC023 bestehen.
Man muss also das große Projekt auf ein kleineres reduzieren, das folgendes macht:

#ol
WiFi Verbindung versuchen herzustellen, wenn der Knopf gedrückt wird.
Beschleunigungsdaten auf dem Touchscreen anzeigen.
Beschleunigungsdaten an den PC schicken, wenn die WiFi-Verbindung steht.

#h2
Aufgabe 2

#ul
Statt dass die WiFi-Verbindung per Knopfdruck hergestellt wird, soll die Uhr selber versuchen sich alle 10 Sekunden zu verbinden, falls keine Verbindung vorliegt.
Setzen Sie dies als Variante des vorangehenden Programms um.

#h3
Aufgabe 3

#ul
Gehen Sie die Liste der Fehlertoleranzpattern durch.
Bestimmen Sie ob und ggf. welche Fehlertoleranzpattern bei der Lösung der Aufgabe 2 zum Einsatz kommen.
Überlegen Sie eine Erweiterung des Programms aus Aufgabe 2, bei dem weitere Pattern zum Einsatz kommen. 
Präsentieren Sie Ihre individuelle Variante.






!!!ENDE

