!!!KURZSCHRIFT
#hauptkapitel
Development of Fault Tolerant Software for Embedded Realtime Systems, winter semester 2025/26 

#box
Start of the course: 9:00 a.m.

#ul
Tasks for those who arrive early:
Download the course text and read it.
Learn how to log in to the PCs in the lab.
Take a look at processing.org and try out some examples on the PCs running Linux.

#ul
Aufgaben für alle, die früher da sind:
Laden Sie sich den Text beim Kurs herunter und lesen ihn.
Lernen Sie, wie Sie sich auf den PCs im Labor einloggen können.
Schauen Sie sich processing.org an und probieren Beispiele auf den PCs unter Linux aus.



#ul
student group: 1 ME

#ul
Here at "day by day," the content covered is noted chronologically over the course of the semester.
In most cases, links are provided within kramann.info where the respective material is presented.
For your reference, you will also find the "day by day" for the same course from the previous year on kramann.info.
The examination in this subject takes place throughout the semester and consists of a project that is presented at the end of the semester.

#h1
Wednesday, September 24, 2025

#h4
Topics today

#ol
Organizational matters
Why do malfunctions occur in Western technology in the first place -- an anthropological perspective
Introduction to the topic of fault tolerance
Introduction to the terms "fault," "error," and "failure"
Introduction to the term "mitigation"
Examples of "mitigation" in modern technology
Division into groups of two
Scheduling appointments for presentations on fault tolerance patterns
Practical application: Smart Watch
Discussion of possible areas in the Smart Watch where fault tolerance can play a role

#ol
Organisatorisches
Warum ergeben sich überhaupt Funktionsstörungen bei der abendländischen Technik -- eine anthropologische Betrachtung
Einführung in das Thema Fehlertoleranz
Einführung der Begriffe "fault", "error" und "failure"
Einführung des Begriffs "mitigation"
Beispiele für "mitigation" in der modernen Technik
Gruppenaufteilung in Zweiergruppen
Terminvereinbarungen für die Präsentationen der Fehlertoleranz Muster
Praktische Anwendung: Smart Watch
Diskussion zu möglichen Bereichen bei der Smart Watch, bei denen Fehlertoleranz eine Rolle spielen kann
Vorübungen mit Java/Processing
Einführung in die Entwicklungsumgebung von Processing

#h4
1. Organizational matters

#ul
The exam takes place throughout the semester and consists of a theoretical presentation, a project assignment, and the presentation of the project assignment at the end of the lecture period.
Students are to work in pairs.
A group list will be circulated for registration.
A fault tolerance pattern will be presented in the theoretical presentation.
In the project work, a smart watch will be programmed and at least two fault tolerance patterns will be applied during implementation.
In the first half of the semester, introductory projects will be carried out together with the smart watch and the basics will be worked out.
From the second half of the semester onwards, work on the projects will mainly take place independently in the groups.
Work on the projects will take place during regular class time.
The final project presentation must represent what has been developed during the semester as seen by the lecturer.
The project part of the exam counts for 80 percent, and the theoretical presentation of a pattern counts for 20 percent of the overall grade.

#ul
Die Prüfung ist semesterbegleitend und besteht aus einer theoretischen Präsentation, einer Projektarbeit und der Präsentation der Projektarbeit am Ende der Vorlesungszeit.
Es soll dazu in Zweiergruppen gearbeitet werden.
Eine Gruppenliste zum Eintragen wird herumgegeben.
In der theoretischen Präsentation wird ein Fehlertoleranz Muster vorgestellt.
In der Projektarbeit wird eine Smart Watch programmiert und mindestens zwei Fehlertoleranz Muster bei der Umsetzung angewendet.
In der ersten Semesterhälfte werden gemeinsam Einführungsprojekte mit der Smart Watch durchgeführt und die Grundlagen erarbeitet.
Ab der zweiten Semesterhälfte finden hauptsächlich die Arbeiten an den Projekten selbstständig in den Gruppen statt.
Die Arbeit an den Projekten erfolgt innerhalb der regulären Unterrichtszeit.
Die abschließende Projektpräsentation muss das repräsentieren, was für den Dozenten sichtbar während des Semesters erarbeitet wurde.
Der Projektteil der Prüfung zählt 80 Prozent, die theoretische Präsentation eines Pattern zählt 20 Prozent der Gesamtnote.

#h4
2. Why do malfunctions occur in Western technology in the first place -- an anthropological perspective

#p
I would like to help you understand what makes Western technology so special.
I would like to work with you to identify the strengths and, if they exist, the fundamental weaknesses of Western technology.
One way to do this is through comparison.
Technical anthropology is a science that compares technologies from different cultures.

#code
Heßler, M., Liggieri, K.: Technikanthropologie: Handbuch für Wissenschaft und Studium, Nomos, Baden-Baden 2020.
Literatur zu Technikanthropologie

#p
As an example, I will use ship navigation in the following.

#br

#aext
https://www.researchgate.net/publication/261594890_Polynesian_Navigation_and_Te_Lapa-_The_Flashing
https://www.researchgate.net/publication/261594890_Polynesian_Navigation_and_Te_Lapa-_The_Flashing
Marianne George (2012) Polynesian Navigation and Te Lapa -- "The Flashing", Time and Mind: The Journal of Archaeology, Consciousness and Culture, 5:2, 135-173, aufgerufen: 22.09.2025, url: https://www.researchgate.net/publication/261594890_Polynesian_Navigation_and_Te_Lapa-_The_Flashing

#br

#p
Example: Boatbuilding in Taumako, documentary film by Michael Tauchert.

#aext
http://mitropico.com/filter/Reihe-Magische-Welten-ZDF/Polynesien-Nomaden-der-Sudsee
http://mitropico.com/filter/Reihe-Magische-Welten-ZDF/Polynesien-Nomaden-der-Sudsee
mitropico.com/filter/Reihe-Magische-Welten-ZDF/Polynesien-Nomaden-der-Sudsee

#p
Visual documentation

#aext
http://vaka.org/
http://vaka.org/
vaka.org -- Taumako Projekt

#p
Navigation with Te Puke Booten -- Dr. Mimi George

#aext
https://www.vaka.org/blog/categories/navigation
https://www.vaka.org/blog/categories/navigation
https://www.vaka.org/blog/categories/navigation

#h5
ÜBUNG

#ul
Discuss the difference between Western technology, with which you are familiar, and the Polynesian art of boat building and navigation.
The Polynesian islands were colonized by various European countries until the 1950s. 
Consider the advantages and disadvantages of the different types of technology, as represented on the one hand by Polynesian navigation and boatbuilding and on the other by their Western counterparts today.
Living with technology: Consider the two types of technology in terms of everyday life. Categories such as happiness and satisfaction are rarely discussed in a technological context, but ultimately, the technologization of the world should have this as its goal. So what is the situation here?

#aext
https://www.researchgate.net/publication/222699397_Goal_Navigation_and_Island-Finding_in_Sea_Turtles
https://www.researchgate.net/publication/222699397_Goal_Navigation_and_Island-Finding_in_Sea_Turtles
Wave interference pattern caused by an island. Kenneth Lohmann und Graeme C Hays:  Goal Navigation and Island-Finding in Sea Turtles, Journal of Experimental Marine Biology and Ecology 356(1-2):83-95 DOI:10.1016/j.jembe.2007.12.017, url: https://www.researchgate.net/publication/222699397_Goal_Navigation_and_Island-Finding_in_Sea_Turtles

#aext
https://de.wikipedia.org/wiki/Polynesische_Navigation#Navigationstechniken
https://de.wikipedia.org/wiki/Polynesische_Navigation#Navigationstechniken
see also: https://de.wikipedia.org/wiki/Polynesische_Navigation#Navigationstechniken

#aext
https://de.wikipedia.org/wiki/John_Harrison_(Uhrmacher)
https://de.wikipedia.org/wiki/John_Harrison_(Uhrmacher)
Clock "H5" by John Harrison, ca. 1770: https://de.wikipedia.org/wiki/John_Harrison_(Uhrmacher)


#h4
3. Introduction to the topic of fault tolerance

#aint
81_FTSD/01_Fehlertoleranz
81_FTSD/01_Fehlertoleranz
81_FTSD/01_Fehlertoleranz

#h4
4. Introduction to the terms "fault," "error," and "failure"

#h5
Exercise

#ol
Describe the concepts of "fault", "error" and "failure".

#h4
5. Introduction to the term "mitigation"

#h4
6. Examples of "mitigation" in modern technology

#h5
Exercise

#ol
Group exercise: Find examples of where modern technology automatically mitigates the effects of errors that occur.

#h4
7. Division into groups of two

#h4
8. Scheduling appointments for presentations on fault tolerance patterns

#h4
9. Practical application: Smart Watch

#img
watch1.png
T-Watch 2020 V3 from Lilygo.


#ul
We will be working with a T-Watch 2020 V3.
This will be done within the Arduino development environment.

#p
These are peripherals that can be controlled by programming on the watch:

#ol
Display
Touch
IMU (Inertia Measurement Unit)
RTC (Real Time Clock)
WiFi
Bluetooth
Button
Vibration
Mikrophone
Loudspeaker

#aext
https://youtu.be/xQJAm8CVC_4
https://youtu.be/xQJAm8CVC_4
Programming examples: https://youtu.be/xQJAm8CVC_4

#aext
https://youtu.be/rJJumsD5vB8
https://youtu.be/rJJumsD5vB8
T-WATCH send Acceleration to Laptop via WiFi: https://youtu.be/rJJumsD5vB8

#br

#ul
So you have a whole list of components that only make sense as a whole when they are linked together in some way by software.
That is exactly what we will be dealing with: linking the internal peripherals of an embedded system together using software to form a useful whole.

#cite
Any sufficiently advanced technology is indistinguishable from magic
Arthur C. Clarke

#br

#p
...in diesem Sinne: 

#ol
How could a smartwatch help support your life on this campus?
Which of the internal peripherals listed above would be used in the application you have proposed?
Which externally available infrastructure would be used by your newly created system?
What disruptions could occur during the interaction of the smartwatch with its environment and the surrounding infrastructure?
What measures could be taken to minimize the impact of the identified potential disruptions? 

#p
Corresponding links, see:

#br

#aext
https://lilygo.cc/products/t-watch-2020-v3
https://lilygo.cc/products/t-watch-2020-v3
Purchase from Lilygo: https://lilygo.cc/products/t-watch-2020-v3

#br

#aext
https://github.com/Xinyuan-LilyGO/TTGO_TWatch_Library
https://github.com/Xinyuan-LilyGO/TTGO_TWatch_Library
TTGO_TWatch_Library V1.4.3: https://github.com/Xinyuan-LilyGO/TTGO_TWatch_Library

#br

#box
necessary: esp32 Board Library 2.09 (exactly this one!)


#h4
10. Discussion of possible areas in the Smart Watch where fault tolerance can play a role

#h1
Wednesday, September 30, 2025

#h4
Topics today

#ol
Quiz
Overview over fault tolerance pattern
Initial collection of ideas on possible applications for the clock and possible fault tolerance patterns that could be used in this context
Presentation: Hello World-program with T-WATCH
Preliminary exercises with Java/Processing
Introduction to the Processing development environment
Presentation: Starting with T-WATCH
Exercise: Hello World-program with T-WATCH


#h4
1. Quiz

#p
Define the terms "fault," "error," and "failure"

#h4
2. Initial collection of ideas on possible applications for the clock and possible fault tolerance patterns that could be used in this context

#code



DAILY LIFE

   SMART HOME: control for children devices: smartphone time etc. by our watch

   recording audio, analyze it to get a warning for dangerous animals e.g.

   step counter (IMU sensor)
   remote control for TV, radio etc. (infrared data transmitter)

   recognition of too intensive sun exposure (Light intensity sensor)

   using bluetooth to connect to the phone for passing messages

   doing calls using microphone and loudspeaker

   performing alarms by using vibration

   games with distributed users

   teach people how to draw -- follow predefined geometrical forms and vibrate when too big difference

   receiving a notification if one has an appointment in the calendar

SPORTS

   compass

   tracking / hiking / climbing mountains
   ...for detecting dangerous areas

   GPS for football player -- tracking and analyze the game to make up new strategies

   detect too high impacts from hits -- inform medical staff

MEDICINE

   Reminder for taking medicine / body sensoring ... measurement of level of insuline e.g.
   heart rate monitoring sensor

   rescue system (alarm if no motion)
   rescue system (alarm if to hard motion)

DISABLED PEOPLE

   support for blind people -- ostacles are provided by external WiFi, let's say on a train station
   Identify type of ground

   Iform about stops in busses by vibration

WORK CONTEXTS

Initial collection of ideas on possible applications for the clock and possible fault tolerance patterns that could be used in this context.

#h4
3. Overview: fault tolerance pattern

#aint
81_FTSD/01_Fehlertoleranz
81_FTSD/01_Fehlertoleranz
81_FTSD/01_Fehlertoleranz

#h4
4. Presentation: Hello World-program with T-WATCH

#h4
5. Preliminary exercises with Java/Processing

#aint
36_Java
36_Java
36_Java

#aint
78_Processing
78_Processing
78_Processing

#br

#aext
https://processing.org/
https://processing.org/
https://processing.org/

#br

#aint
74_EmbSyst/02_Eingebettete_Systeme/03_Android/06_Processing
74_EmbSyst/02_Eingebettete_Systeme/03_Android/06_Processing
74_EmbSyst/02_Eingebettete_Systeme/03_Android/06_Processing

#h4
6. Introduction to the Processing development environment

#p
...will be done on PCs.

#h4
7. Presentation: Starting with T-WATCH

#aint
07_TWATCH_EN
07_TWATCH_EN
07_TWATCH_EN -- english version.

#aint
06_TWATCH
06_TWATCH
06_TWATCH -- german version.

#h4
8. Exercise: Hello World-program with T-WATCH

#aint
07_TWATCH_EN/03_Hello_world
07_TWATCH_EN/03_Hello_world
Follow steps here: 07_TWATCH_EN/03_Hello_world.

#br
#br

#h1
Wednesday, October 07, 2025

#br

#h4
Topics today

#ol
Organization of presentation dates for fault tolerance patterns
Systematic introduction to programming the watch
Small programming tasks for using the screen, touchscreen, button, IMU sensor, and real-time clock.
Small project for an application program using the internal peripherals covered so far

#h4
1. Organization of presentation dates for fault tolerance patterns

#code

WEDNESDAY 15.10. 22.10. 29.10. 
          05.11. 12.11. 19,11,
          --------------------
          26.11. 03.12. 10.12.
          17.12.
Dates for the presentations.

#ul
Appointments according to the group list

#h4
2. Systematic introduction to programming the watch

#ol
Basic structure of a C/C++ program
Hello world program, processing in the console
Comparison of standard C programs with program structure for the clock
Declaration and initialization of variables
Variable types
Functions in C/C++
Transfer and return values for functions
Distinction between call by value and call by reference
Classes and objects in C++ and Java

#h5
Programs made during the course:

#code
#include <iostream>
using namespace std;
int main(void)
{
    cout<<endl<<"Hello world!"<<endl;
    return 0;
}
hello.cpp

#code
#include <iostream>
using namespace std;

int x=7; // declaration and initialization == definition
char y='4';
char text[]="My text."; // ends with 0 == '\0'
int main(void)
{
    cout<<endl<<"Hello world! "<<"x="<<x<<endl;
    cout<<(int)y<<endl;
    cout<<text<<endl;
    cout<<size(text)<<endl;
    return 0;
}
hello2.cpp (variables)

#code
#include <iostream>
using namespace std;

int mult(int x, int y)
{
   int z = x*y;
   return z;
}

int main(void)
{
    cout<<"4*5="<<mult(4,5)<<endl;
    return 0;
}
hello3.cpp

#code
#include <iostream>
using namespace std;

bool hasE(char text[])
{
   int index = 0;
text[0]='#';
   while(text[index]!='\0')
   {
       if(text[index]=='e' || text[index]=='E')
           return true;
       index++;
   }
   return false;
}

int main(void)
{
    char sentence1[] = "This is cool!";
    char sentence2[] = "This is an elephant!";

    cout<<sentence1<<" ..has an e?:"<<hasE(sentence1)<<endl;
    cout<<sentence2<<" ..has an e?:"<<hasE(sentence2)<<endl;
    cout<<sentence1<<endl;
    cout<<sentence2<<endl;

    return 0;
}
hello4.cpp (call by reference)

#code
#include <iostream>
#include <math.h>
using namespace std;
class Vektor
{
    public:
       double x,y;
   
       double calculateLength()
       {
           return sqrt(x*x+y*y);
       }
}; 
int main(void)
{
    Vektor v1,v2;
    v1.x=3.0;
    v1.y=4.0;
    v2.x=1.0;
    v2.y=0.0;
    double l1 = v1.calculateLength();
    double l2 = v2.calculateLength();
    cout<<"|v1|="<<l1<<endl;
    cout<<"|v2|="<<l2<<endl;
    return 0;
}
hello5.cpp (explain classes and objects in objectoriented programing)




#h4
3. Small programming tasks for using the screen, touchscreen, button, IMU sensor, and real-time clock.

#ul
The list of simplified commands has been expanded specifically for the internal peripheral elements listed here.
To complete the following tasks, refer to the descriptions and examples here:

#aint
07_TWATCH_EN/04_Simplified_Commands
07_TWATCH_EN/04_Simplified_Commands
07_TWATCH_EN/04_Simplified_Commands


#p
Exercise 1: Switsch Background color by pressing the button multiple times between
red, green, blue, red, green, blue, red, ... and so on.

#code
#include "twatch.h"
#include "variables.h"
#include "functions.h"
 int state=0;
void setup() 
{
    setupTWATCH();
    backlight(true); 
    
}

void loop() 
{
  
    if(button()) {
      state++;
      if(state > 2){
        state=0;
      }
      switch(state){
        case 0:
        background(255,0,0);
       break;
       case 1:
       background(0,255,0);
       break;
       case 2:
       background(0,0,255);
       break;
      }
    }
    
    
    delay(100);  
}
Student solution.

#p
Exercise 2: Program a type of water clock. 
The deviation of the clock from the horizontal position should be visualized 
graphically by moving a small circle on the display away from the center of the display.

#code
#include "twatch.h"
#include "variables.h"
#include "functions.h"

float skalierung=0.5;
float KreisX=0;
float KreisY=0;
void setup() 
{
    setupTWATCH();
    backlight(true); 
}

void loop() 
{
    bool res = acceleration();

  if(KreisX>240){
    KreisX=240;
  }else if(KreisX<0){
    KreisX=0;
  }else{
    KreisX = 120 - (float)(accY*skalierung);
  }
  if(KreisY>240){
    KreisY=240;
  }else if(KreisY<0){
    KreisY=0;
  }else{
    KreisY = 120 + (float)(accX*skalierung);
  }
  

 fill(0,0,255);
 circle(KreisX,KreisY,20);
    delay(50);
    clear();
    delay(50);
}
Student solution.

#p
Exercise 3: Program a type of stopwatch.
The stopwatch should be accurate to one-hundredth of a second.
To do this, analyze in project "TWATCH_PROC023" the "functions.h" tab to find out how to obtain the elapsed time in milliseconds.


#h4
4. Small project for an application program using the internal peripherals covered so far

#p
Implement the following project: A warning system should sound an alarm via the vibration motor and a suitable display if the watch is not held horizontally for more than 10 seconds.

#h1
Wednesday, October 15, 2025

#h4
Topics today

#ol
Discussion of useful literature
Analysis of last week's projects
Notes on Internet programming
Data transfer via Wi-Fi
Transferring a Processing sketch to a mobile device
EXERCISE: Implementing an initial fault tolerance concept
Continuing collecting project ideas

#h4
1. Discussion of useful literature

#p
The source for fault tolerance patterns is Hanmer's book:

#ul
Hanmer, R.S., “Patterns for Fault Tolerant Software,” John Wiley & Sons, Weinheim 2007.

#p
To understand how to program an esp32, you can use the relevant programming manuals:

#ul
Brandes, U., “Mikrocontroller ESP32,” Rheinwerk, Bonn 2020.

#p
It may also be worthwhile to learn more about Processing, as the simplified programming of the clock is based on it:

#ul
Shiffman, D., “Learning Processing: A Beginner's Guide to Programming Images, Animation, and Interaction,” Morgan Kaufmann, Burlington 2015.

#p
If you also want to use a smartphone as a remote station, the following book is worth reading, as it covers the development of Android apps based on Processing:

#ul
Sauter, D., “Rapid Android Development,” The Pragmatic Bookshelf, Dallas 2013.

#p
Books of this type can be helpful. It does not necessarily have to be these specific ones.
In addition to the THB library, you can also use the TU library (Volkswagen Library) in Berlin, near the bus station/Zoologischer Garten station.

#h4
2. Analysis of last week's projects

#h4
3. Notes on Internet programming

#aint
30_Informatik3/16_Nuetzliches/05_Internetprogrammierung/04_Java
30_Informatik3/16_Nuetzliches/05_Internetprogrammierung/04_Java
30_Informatik3/16_Nuetzliches/05_Internetprogrammierung/04_Java

#h4
4. Data transfer via Wi-Fi 

#aext
https://youtu.be/rJJumsD5vB8
https://youtu.be/rJJumsD5vB8
T-WATCH send Acceleration to Laptop via WiFi: https://youtu.be/rJJumsD5vB8

#ul
The above example shows a special use of the smartwatch, in which acceleration data from the watch is sent to a PC via Wi-Fi.
Since two devices are communicating with each other via radio waves, a number of things can go wrong.

#h5
EXERCISE

#ul
List possible sources of error that may occur when attempting to establish a data connection between the watch and the PC via Wi-Fi.


#h2
Concept for establishing a data connection via Wi-Fi

#ul
The well-known TWATCH_PROC023 project has the ability to send acceleration data to a PC via Wi-Fi.
As soon as the button is pressed, it checks whether a Wi-Fi connection is available and, if not, attempts to establish one:

#code
    if(button()) //wird ausgeführt, wenn Knopf gedrückt
    { 
        if(!WIFIOKAY) //Falls WIFi NICHT verfügbar
        {
            setupWIFI(hotspot,password,udpport); //...Verbindungsversuch starten
        }
        ....
     }
Main tab of project TWATCH_PROC023 from line 227 onwards.

#ul
Once the WiFi connection is established, the acceleration data is sent to the PC cyclically in MODE No. 2 on the watch:

#code
      case 2: //Acceleration (Switch Anweisung bei MODE 2)
      {
        backlight(true);
        cursor(0,0);
        bool res = acceleration();            //Auslesen der Beschleunigungswerte
        if(WIFIOKAY && udp.listen(UDPPORT))   //Wenn WiFi Verbindung vorhanden und ein Datenpaket vom PC empfangen wird...
        {
            udp.onPacket([](AsyncUDPPacket packet) 
            {
                if(Serial) Serial.write(packet.data(), packet.length());            
                if(Serial) Serial.println();
                packet.printf("accX=%d accY=%d accZ=%d", accX,accY,accZ);  //Übertrage die Beschleunigungsdaten          
            });      
        }
        ...
      }
      ...
Main tab of project TWATCH_PROC023 from line 110 onwards.

#ul
The following important data and libraries must be provided in the header of the main tab:

#code
#include "twatch.h"
#include "variables.h"
#include "functions.h"

...

const char* hotspot = "hotspotX";
const char* password = "12345678";
int udpport = 6000;
...

Main tab of project TWATCH_PROC023 from line 1 onwards.

#ul
Im setup() wird die Uhr folgendermaßen konfiguriert:

#code
void setup() 
{
    setupTWATCH();
    setupSERIAL(115200);
    setupWIFI(hotspot,password,udpport); Bereits hier wird ein Verbindungsversuch gestartet
    setupMotor();
    //setFont(3);
    //setFont(2,255,55,0,  0,0,0);
    setFont(1, 255,255,255,  255,0,0);
    updateTime(); //RTC Zeit nehmen
    backlight(true); 
}
Main tab of project TWATCH_PROC023 from line 1 onwards.

#h2
PC-side program

#ul
A processing program is used on the PC side to establish the WiFi connection with the clock.
In addition, a hotspot must be provided to which both devices must be connected.
PLEASE NOTE: The PCs in the PC pool are not WiFi-enabled. Smartphones or laptops can be used to carry out experiments.


#zip
TWATCH_PROC005_hotspot.zip
TWATCH_PROC005_hotspot.zip -- Processingsketch für den PC-seitigen Part.

#zip
TWATCH_PROC005_hotspot_ANDROID.zip
TWATCH_PROC005_hotspot_ANDROID.zip -- Android version of the project.

#code
import hypermedia.net.*;
String IP = "10.42.0.255"; 
int PORT = 6000; //für UDP benötigt.
UDP udp;

String NACHRICHT="";

public void setup()
{
    size(700,500);
    udp = new UDP( this, 6000 );
    udp.listen( true ); 
    frameRate(10);
}

public void draw()
{
    background(255);
    fill(0);
    textSize(20);
    text("Empfangen:",30,30);
    text(NACHRICHT,30,60);     //Nachricht der Uhr ggf. anzeigen.
    
    udp.send("Test", IP, PORT );  //Zyklisch einen "PING" an die Uhr schicken.
}

   void receive( byte[] data, String ip, int port ) //Callback Funktion, die auf hereinkommende Pakete reagiert.
   {  
      // <-- extended handler  
      // get the "real" message =
      // forget the ";\n" at the end <-- !!! only for a communication with Pd !!!
      //data = subset(data, 0, data.length-2);
      String x = new String( data );
      if(x!=null && !x.equals("Test"))  //Nachricht der Uhr bereitstellen.
         NACHRICHT = x;
   }     
Processing sketch for the PC/laptop side.

#h4
5. Transferring a processing sketch to a mobile device


#h5
6. EXERCISE: Implementing an initial fault tolerance concept

#h2
Exercise 1

#ul
Over the past two weeks, we have discussed small sample programs for various internal peripherals.
Write your own sample program related to WiFi.
It should consist of the parts discussed above from the TWATCH_PROC023 project.
This means you need to reduce the large project to a smaller one that does the following:

zip
studentischeloesung1.zip
studentischeloesung1.zip

#ol
Attempt to establish a WiFi connection when the button is pressed.
Display acceleration data on the touchscreen.
Send acceleration data to the PC when the WiFi connection is established.

#h2
Exercise 2

#ul
Instead of establishing the WiFi connection at the touch of a button, the watch should attempt to connect every 10 seconds if no connection is available.
Implement this as a variant of the previous program.

#h3
Exercise 3

#ul
Go through the list of error tolerance patterns.
Determine whether and, if so, which error tolerance patterns are used in solving task 2.
Consider an extension of the program from task 2 in which additional patterns are used.
Present your individual variant.

#h4
7. Continuing collecting project ideas

#box
...see above:

#h4
2. Initial collection of ideas on possible applications for the clock and possible fault tolerance patterns that could be used in this context

#h1
Wednesday, October 22, 2025

#h4
Topics today

#ol
Presentation #1: Redundancy
Data transfer via Wi-Fi -- Snippet
Modification of Wi-Fi -- Snippet towards a fault tolerant variant
Discussion about fault tolerant patterns applied in modified Wi-Fi -- Snippet
Analysing object oriented structure of TWATCH_PROC023 project 
Continuing collecting project ideas
Exercises

#h4
1. Presentation #1: Redundancy

#h4
2. Data transfer via Wi-Fi -- Snippet

#aint
07_TWATCH_EN/04_Simplified_Commands
07_TWATCH_EN/04_Simplified_Commands
see "WiFi" here 07_TWATCH_EN/04_Simplified_Commands

#h4
3. Modification of Wi-Fi -- Snippet towards a fault tolerant variant

#h4
4. Discussion about fault tolerant patterns applied in modified Wi-Fi -- Snippet

#h4
5. Analysing object oriented structure of TWATCH_PROC023 project 

#h3
Pointer-to-Object-Example in C++ to explain special structure of original examples from TTGO library

#code
#include <iostream>
#include <math.h>
using namespace std;
class Vektor
{
    public:
       double x,y;
   
       double calculateLength()
       {
           return sqrt(x*x+y*y);
       }
}; 

Vektor *vektor;

int main(void)
{
    Vektor v1,v2;

    Vektor *v3;

    v3 = &v1;

    vektor = new Vektor();

    //v1.x=3.0;
    //v1.y=4.0;
    v3->x=3.0;
    vektor->y=4.0;
    vektor->x=3.0;
    v3->y=4.0;
    v2.x=1.0;
    v2.y=0.0;
    //double l1 = v1.calculateLength();
    double l1 = vektor->calculateLength();
    double l2 = v2.calculateLength();
    cout<<"|v1|="<<l1<<endl;
    cout<<"|v2|="<<l2<<endl;
    return 0;
}
Pointer-to-Object-Example in C++ to explain special structure of original examples from TTGO library

#box
Several objects are declared in twatch.h:

#code
//Several objects are declared in twatch.h:
AudioFileSourceFunction* file_wav;
AudioOutputI2S *output_wav;
AudioGeneratorWAV* wav_generator;

AsyncUDP udp;

/*
                          Zeilen  Spalten
    tft->setTextFont(8);    3        4
    tft->setTextFont(6);    5        8
    tft->setTextFont(4);    9       16
    tft->setTextFont(2);   15       29

 */

TTGOClass *watch;
TFT_eSPI *tft;
BMA *sensor;
BackLight *hintergrundlicht; //Um es manipulieren zu können!!!
Extract from twatch.h from TWATCH_PROC023 project 

#ul
tft is a pointer to an object.
tft->setTextFont(2); calls the object method setTextFont() inside the tft-object. 

#code
void setupTWATCH()
{
    ....
    //Provide the t-watch-object in pointer watch:
    watch = TTGOClass::getWatch();
    ....
    //Provide tft (screen) object in pointer tft.
    //It is taken from the inner of watch.
    tft = watch->tft;
    ....
}
Method setupTWATCH() -- Extract from twatch.h from TWATCH_PROC023 project,  

#box
Helpful methods are provided in an easy to use way in functions.h

#code
void clear()
{
    watch->tft->fillScreen(TFT_BLACK); // Clear screen  
}
...
bool touch()
{
    int16_t x,y;
    bool tch = watch->getTouch(x,y);
    mouseX=x;
    mouseY=y;
    return tch;
}
...
// drawLine(int32_t xs, int32_t ys, int32_t xe, int32_t ye, uint32_t color),
void line(int x1, int y1, int x2, int y2, int R, int G, int B)
{
    tft->drawLine(x1, y1, x2, y2, 
    ((255>>4))+((R>>4)<<12)+((G>>4)<<8)+((B>>4)<<4)
    
    );
}
...
void line(int x1, int y1, int x2, int y2)
{
    tft->drawLine(x1, y1, x2, y2, 
    ((STROKE_ALPHA>>4))+((STROKE_RED>>4)<<12)+((STROKE_GREEN>>4)<<8)+((STROKE_BLUE>>4)<<4)
    
    );

}

Examples for definition of easy to use functions in functions.h for discussion.

#box
Where you can get the information to extend the simple functions?

#p
see:

#ul
/home/fhbstud/Arduino/libraries/TTGO_TWatch_Library-1.4.3/src/libraries/TFT_eSPI/TFT_eSPI.h
Line 872
    void     drawCircle(int32_t x, int32_t y, int32_t r, uint32_t color),
...from this own methods can be derived which encapsulate the original ones.

#box
Which header-files contain interfaces for which internal periphery?:

#ul
Control watch: /TTGO_TWatch_Library-1.4.3/src/TTGO.h
TFT screen: /TTGO_TWatch_Library-1.4.3/src/libraries/TFT_eSPI/TFT_eSPI.h 
IMU sendor: /TTGO_TWatch_Library-1.4.3/src/drive/mup6050/MPU6050.h
Button: /TTGO_TWatch_Library-1.4.3/src/drive/button/Button2.h
...

#h5
Relevant examples available in TTGO_TWatch_Library-1.4.3: Datei->Beispiele->TTGO TWatch Library->BasicUnit

#ul
Direct access via file system: /home/fhbstud/Arduino/libraries/TTGO_TWatch_Library-1.4.3/examples/BasicUnit/

#img
bsp.png
Achieving the examples from TTGO_TWatch_Library-1.4.3

#h4
6. Continuing collecting project ideas

#h4
7. Exercises


#h5
Exercise #1 -- Escalation

#p
Implement the following scenario with the smartwatch:

#ul
Pressing the button should start a 60-second countdown.
The countdown should be shown on the display.
When zero seconds is reached, the display should flash.
If not confirmed by pressing a button within 5 seconds, the vibration motor will also start.

#code
#include "twatch.h"
#include "variables.h"
#include "functions.h"


int countdown = 10;
int state = 0;
long Alarmzeit = 0;
int Alarminterval = 5000;
int tickinterval = 1000;
long lasttick = 0;
bool Knopf = false;

void setup() {
  setupTWATCH();
  setFont(1, 255, 255, 255,  255, 0, 0);
  setupMotor();
  backlight(true);

  clear();
}

void loop() {
  if (button())
  {
    state++;
    if (state > 2) {
      state = 0;
    }
  }
  switch (state) {
    case 0:
      background(0, 255, 0);
      countdown = 10;
      break;
    case 1:
      if (countdown > 0)
      {
        if (millis() - lasttick > tickinterval)
        {
          clear();
          cursor(0, 0);
          editor(countdown);
          countdown--;
          lasttick = millis();

        }
      }
      if (countdown == 0)
      {
        state = 2;
        Alarmzeit = millis();
      }
      break;
    case 2:
      background(255, 0, 0);
      delay(500);
      clear();
      delay(500);
      if (button())
      {
        Knopf = true;
      }
      if (millis() - Alarmzeit > Alarminterval && Knopf == false)
      {
        motor();
      } else if (Knopf == true)
      {
        state = 0;
      }
      break;

  }
  delay(50);
}
student solution.

#code
#include "twatch.h"
#include "variables.h"
#include "functions.h"
void setup() 
{
    setupTWATCH();
    setFont(1, 255,255,255,  255,0,0);
     setupMotor();
    backlight(true); 
}  
int COUNTDOWN = 100; 
bool COUNTDOWN_STARTED = false;
bool TOGGLE = true; //for flashing
void loop() 
{
    if(button())
    {
        if(COUNTDOWN_STARTED==true)
        {
            COUNTDOWN_STARTED = false;
            COUNTDOWN = 100; //RESET 
        }
        else
        {
            COUNTDOWN_STARTED = true;
        }    
    }
  
    clear();
    cursor(0,0);
    editor(COUNTDOWN/10);
    editor("\\n");
    if(COUNTDOWN_STARTED==true && COUNTDOWN>0)
    {
        COUNTDOWN--;
    }    
    else if(COUNTDOWN_STARTED==true && COUNTDOWN<=0)
    {
        if(TOGGLE==true)
        {
            background(255,0,0);            
        }
        else
        {
            background(0,255,0);                      
        }
        TOGGLE = !TOGGLE;

        if(COUNTDOWN<-50)
        {
            motor();
        }
    }
    
    delay(100);  //making button more reactive
}
second solution.

#h5
Exercise #2 -- Continuation from last week

#ul
Instead of establishing the WiFi connection at the touch of a button, the watch should try cyclically every 10 seconds if unsuccessful so far.

#h5
Exercise #3

#ul
Find out how the light sensor can be programmed.
Summarize the use of the light sensor in an easy-to-use function.
Provide a small application example.

#h1
Wednesday, October 29, 2025

#h4
Topics today

#ol
DATE RESCHEDULED TO NOVEMBER 04, 2025: Presentation #2: Software Update 
DATE RESCHEDULED TO NOVEMBER 04, 2025: Presentation #3: Correcting Audits
Using the Internal Microphone of T-WATCH V3
Smart Home Application with T-WATCH V3 
More Literature
Continuing Collecting Project Ideas / Decision for your project
Exercises

#h4
1. Presentation #2: Software Update

#h4
2. Presentation #3: Correcting Audits

#h4
3. Using the Internal Microphone of T-WATCH V3

#aint
07_TWATCH_EN/05_Microphone
07_TWATCH_EN/05_Microphone
07_TWATCH_EN/05_Microphone (english)

#aint
06_TWATCH/05_Microphone
06_TWATCH/05_Microphone
06_TWATCH/05_Microphone (deutsch)


#h4
4. Smart Home Application with T-WATCH V3 

#aint
06_TWATCH/06_SmartHome
06_TWATCH/06_SmartHome
06_TWATCH/06_SmartHome (english)

#aint
06_TWATCH/06_SmartHome
06_TWATCH/06_SmartHome
06_TWATCH/06_SmartHome (deutsch)

#h4
5. More Literature

#ul
Bertko, C., Weber, T., Home Smart Home - Der praktische Einstieg in die Hausautomation, Hanser, München 2017.
Butz, A., Krüger, A., Mensch-Maschine-Interaktion, de Gruyter, Berlin 2017.
Sadek, I. et. al., Novel Unobtrusive Approach for Sleep Monitoring Using Fiber Optics in an Ambient Assisted Living Platform, S.48-60 in: Enhanced Quality of Life and Smart Living, Springer LNCS 10461, Cham 2017. 
Seiderer, A., Dang, C.T., André, E., Exploring Opportunistic Ambient Notifications in the Smart Home to Enhance Quality of Live, S.151-160 in: Enhanced Quality of Life and Smart Living, Springer LNCS 10461, Cham 2017.
Treviranus, J., Teaching Our Machines to be Smart, Not Prejudiced, S.XIII in: Enhanced Quality of Life and Smart Living, Springer LNCS 10461, Cham 2017. 

#ul
The following articles were found by searching with the key words: research gate smart watch helper in surgery:

#aext
https://www.researchgate.net/publication/355680960_Wearable_Technology_for_Assessment_and_Surgical_Assistance_in_Minimally_Invasive_Surgery
https://www.researchgate.net/publication/355680960_Wearable_Technology_for_Assessment_and_Surgical_Assistance_in_Minimally_Invasive_Surgery
Wearable Technology for Assessment and Surgical Assistance in Minimally Invasive Surgery, by Juan A. Sánchez-Margallo, José Castillo Rabazo, Carlos Plaza de Miguel, Peter Gloor, David Durán Rey, Manuel Ramón González-Portillo, Isabel López Agudelo and Francisco M. Sánchez-Margallo, web resource, url: https://www.researchgate.net/publication/355680960_Wearable_Technology_for_Assessment_and_Surgical_Assistance_in_Minimally_Invasive_Surgery, October 28, 2025.

#aext
https://www.researchgate.net/publication/382372496_Smartwatch_interventions_in_healthcare_A_systematic_review_of_the_literature
https://www.researchgate.net/publication/382372496_Smartwatch_interventions_in_healthcare_A_systematic_review_of_the_literature
Smartwatch interventions in healthcare: A systematic review of the literature, by Andreas Triantafyllidisa, Haridimos Kondylakisb, Dimitrios Katehakisb, Angelina Kouroubalib, Anastasios Alexiadisa, Sofia Segkoulia, Konstantinos Votisa, and Dimitrios Tzovarasa, web resource, url: https://www.researchgate.net/publication/382372496_Smartwatch_interventions_in_healthcare_A_systematic_review_of_the_literature,  October 28, 2025.

#ul
The following articles were found by searching with the key words: research gate smart watch help for elder people

#aext
https://www.researchgate.net/publication/364082021_Healthcare_Smartwatch_for_Monitoring_Elderly
https://www.researchgate.net/publication/364082021_Healthcare_Smartwatch_for_Monitoring_Elderly
Healthcare Smartwatch for Monitoring Elderly, by Kush Rawal, Goldie Gabrani, web resource, url: https://www.researchgate.net/publication/364082021_Healthcare_Smartwatch_for_Monitoring_Elderly, ,  October 28, 2025.

#aext
https://www.researchgate.net/publication/265093269_Supporting_Elderly_Homecare_with_Smartwatches_Advantages_and_Drawbacks
https://www.researchgate.net/publication/265093269_Supporting_Elderly_Homecare_with_Smartwatches_Advantages_and_Drawbacks
Supporting Elderly Homecare with Smartwatches: Advantages and Drawbacks, by Frederic EHRLER and Christian LOVIS, web resource, url: https://www.researchgate.net/publication/265093269_Supporting_Elderly_Homecare_with_Smartwatches_Advantages_and_Drawbacks, October 28, 2025.


#h4
6. Continuing Collecting Project Ideas / Decision for your project

#box
Today, the first participants should decide on a specific project idea and start working on the project.

#h4
7. Exercises

#ol
Find in mimimum one more interesting online article about a smart watch application and present it in the course.
Try out the microphone example and develop an authentication method that works with whistling.
Think about other possible applications for the internal microphone.
Think about applications in the smartwatch sector in combination with smart homes.
Develop the following system: The screen background on the smartphone can be switched between white and black at the touch of a button on the watch.

#h1
Wednesday, November 05, 2025

#box
Aufgrund anhaltender Bahnprobleme starten wir heute um 09:15Uhr.

#box
Due to ongoing rail problems, we will start at 9:15 a.m. today.

#h4
Topics today

#ol
Presentation #2: Software Update 
Presentation #4: Maintenance Interface
Reading the temperature on the acceleration sensor
Defining the project topics

#h4
1. Presentation #2: Software Update

#h4
2. Presentation #4: Maintenance Interface

#h4
3. Reading the temperature on the acceleration sensor

#aint
07_TWATCH_EN/07_Temperature
07_TWATCH_EN/07_Temperature
07_TWATCH_EN/07_Temperature

#aint
06_TWATCH/07_Temperature
06_TWATCH/07_Temperature
06_TWATCH/07_Temperature


#h4
4. Defining the project topics

#h1
Wednesday, November 12, 2025

#box
Aufgrund anhaltender Bahnprobleme starten wir heute um 09:20Uhr.

#box
Due to ongoing rail problems, we will start at 9:20 a.m. today.

#h4
Topics today

#ol
Presentation #3: Correcting Audits
End of defining the project topics
Starting work on projects / Ongoing discussion of projects

#h5
ARRAY example from today

#zip
TWATCH_PROC023_ARRAY001.zip
TWATCH_PROC023_ARRAY001.zip

#zip
TWATCH_PROC023_ARRAY002.zip
TWATCH_PROC023_ARRAY002.zip

#zip
TWATCH_PROC023_ARRAY003.zip
TWATCH_PROC023_ARRAY003.zip

#zip
TWATCH_PROC023_ARRAY004.zip
TWATCH_PROC023_ARRAY004.zip

#h1
Wednesday, November 19, 2025

#h4
Topics today

#ol
Presentation: Correcting Audits
Presentation: Minimize Human Intervention
Presentation: Maximize Human Participation
Presentation: Someone in Charge
Work on projects

#h1
Wednesday, November 26, 2025

#h4
Topics today

#ol
Understanding and Discussion: Recovery Block
Work on projects

#h1
Wednesday, December 3, 2025

#h4
Topics today

#ol
Understanding and Discussion:  Escalation
Work on projects

#h1
Wednesday, December 10, 2025

#h4
Topics today

#ol
Understanding and Discussion:  Mitigation
Work on projects

#h1
Wednesday, December 17, 2025

#h4
Topics today

#ol
Understanding and Discussion:  Fault Observer
Work on projects
!!!ENDE

