public interface iEingangsFuzzySet
{
    /**
         breite ist der Abstand zwischen der am weitesten links liegenden Fuzzy-Größe und
         der am weitesten rechts liegenden.
         Alle Fuzzy-Größen werden äquidistant angeordnet.
    */
    public abstract void setzeStuetzpunkte(double breite); 
    /** Liefert Erfülltheitsgrad einer bestimmten Fuzzy-Größe */
    public abstract double berechneErfuelltheitsgrad(int index, double x);    
}

public class EingangsFuzzySet implements iEingangsFuzzySet
{
    int anzahlFuzzygroessen;
    double breite;
    
    public EingangsFuzzySet(int anzahlFuzzygroessen, double breite)
    {
        this.anzahlFuzzygroessen = anzahlFuzzygroessen;
        this.breite = breite;
    }
  
    public void setzeStuetzpunkte(double breite)
    {
        this.breite = breite; //das reicht.
    }
    public double berechneErfuelltheitsgrad(int index, double x)
    {
        double d = breite/(double)(anzahlFuzzygroessen-1);
        double m = 1.0/d;
        
        if(x<=-breite*0.5)
        {
             if(index==0)
                return 1.0;
             else
                return 0.0;
        }
        else if(x>=breite*0.5)
        {
             if(index==anzahlFuzzygroessen-1)
                return 1.0;
             else
                return 0.0;
        }
        else //...
        {
             //Bereiche durchgehen:
             for(int i=0;i<anzahlFuzzygroessen-1;i++)
             {
                  if(x>=-breite*0.5+d*(double)i && x<=-breite*0.5+(double)(i+1)*d)
                  {
                      //Index beteiligter Fuzzy-Größen ist hier:
                      //   i und i+1
                      //Wenn linke der Fuzzy-Größen ...
                      if(index==i)
                      {
                           return 1.0 - m*(x-(-breite*0.5+d*(double)i)); //ist komplementär zur zweiten
                      }
                      //Wenn gefragte Fuzzy-Größe rechte der aktuell betrachteten...
                      else if(index==i+1)
                      {
                           //dann Steigung positiv berücksichtigen:
                           return m*(x-(-breite*0.5+d*(double)i));
                      }
                  }
             }
        }
        return 0.0;
    }
}
