public class FuzzySystem
{
  public double[] systemA(double A)
  {
    double[] a = new double[3];
    if(A<=2.0)
    {
        a[0]=1.0;
        a[1]=0.0;
        a[2]=0.0;
    }
    else if( A>2.0 && A<=3.0 )
    {
        a[0]=-A+3.0;
        a[1]=A-2.0;
        a[2]=0.0;
    }    
    else if( A>3 && A<=4 )
    {
        a[0]=0.0;
        a[1]=-A+4.0;
        a[2]=A-3.0;
    }
    else//if A>4 then
    {
        a[0]=0.0;
        a[1]=0.0;
        a[2]=1.0;
    }
    
    return a;
  }        //endfunction

  public double[] systemB(double B)
  {
    return systemA(B);
  }

  public double flaecheTrapez(double h)
  {
    double q = 2.0;
    double p = 2.0*(1.0-h);
    double A = h*(p+q)/2.0;
    return A;
  }

  public double minimum(double x, double y)
  {
     if(x>y)
        return y;
     else
        return x;
  }

  public double berechneC(double A, double B)
  {
    double[] a=systemA(A);
    double[] b=systemB(B);
    
    double Reg1=minimum(a[0],b[2]);
    double Reg2=minimum(a[1],b[1]);
       
    double A1=flaecheTrapez(Reg1);
    double A2=flaecheTrapez(Reg2);
    
    double s1=4;
    double s2=5;
    
    double C=(s1*A1+s2*A2)/(A1+A2);
    return C;
  }
}// class FuzzySystem
