public class Einachser implements iModell
{
/*  
clear();

m = 1;     //kg
g = 0.91;  // m/s^2
l = 1;     // m
h = l/2;   // m
r = 0.1;   // m

// siehe: http://www.kramann.info/54_Kinetik/02_NewtonEuler/01_Traegheitsmomente
J = 0.25*m*r*r + (1/12)*m*l*l; // kg*m^2 

A = [ 0 , 1  ;  m*g*h/J , 0 ];
B = [ 0 ; h/J ];

spec(A) //Eigenwerte der ursprünglichen Matrix ansehen
// ergibt:
//   2.3023837 + 0.i
//  -2.3023837 + 0.i

// technisch stabil wählen, an vorhandenen Werten orientieren:

EW = [-2.3023837 + %i*2.3023837 , -2.3023837 - %i*2.3023837 ];

R = ppol(A,B,EW)
// ergibt (korrigiert 5.1. wg. verändertem B):
// 2.7299999   0.7904851

//testweise diesen Regler in das nicht linearisierte Modell einbauen und testen:

function f = rechteSeite(t,y)
    phi = y(1,1);
    om  = y(2,1);
    f(1,1) = om;
    FA = -R * [phi;om];
    N = J + m*h*h*sin(phi)*sin(phi);
    f(2,1) = (-m*h*h*om*om*sin(phi)*cos(phi) + h*m*sin(phi)*g + h*cos(phi)*FA )/N;
endfunction

t = linspace(0,20,3000);
y0 = [10.0*%pi/180,0.0]';  //Start in der Nähe der instabilen Ruhelage
t0 = 0;
y  = ode(y0,t0,t,rechteSeite);

plot(t,y(1,:)',t,y(2,:)');  
*/  

     //Modellparameter definieren:
     double m = 1.0;     //kg
     double g = 0.91;  // m/s^2
     double l = 1.0;     // m
     double h = l/2.0;   // m
     double r = 0.1;   // m

     // siehe: http://www.kramann.info/54_Kinetik/02_NewtonEuler/01_Traegheitsmomente
     double J = 0.25*m*r*r + (1.0/12.0)*m*l*l; // kg*m^2 

     double[][] A = { {0.0 , 1.0  },  {m*g*h/J , 0.0} };
     double[]   B = { 0.0 , h/J };
  
     //aus ppol genommene Parameter des Zustandsreglers:
     double[] R = {2.7299999,   0.7904851};
  
     public Einachser() //Parameter liegren hier schon fest.
     {
     }
  
     public int getAnzahlGleichungen()
     {
           return 2;
     }
     public void steigung(double t, double[] y, double[] f)
     {
        double phi = y[0];
        double om  = y[1];
        f[0] = om;
        double FA = -R[0]*phi - R[1]*om;
        double N = J + m*h*h*Math.sin(phi)*Math.sin(phi);
        f[1] = (-m*h*h*om*om*Math.sin(phi)*Math.cos(phi) + h*m*Math.sin(phi)*g + h*Math.cos(phi)*FA )/N;
     }     
}
