void println(char* text) { if(SERIALOKAY) Serial.println(text); }
void print(char* text) { if(SERIALOKAY) Serial.print(text); }
void println(int x) { if(SERIALOKAY) Serial.println(x); }
void print(int x) { if(SERIALOKAY) Serial.print(x); }
void println(unsigned int x) { if(SERIALOKAY) Serial.println(x); }
void print(unsigned int x) { if(SERIALOKAY) Serial.print(x); }
void println(long x) { if(SERIALOKAY) Serial.println(x); }
void print(long x) { if(SERIALOKAY) Serial.print(x); }
void println(unsigned long x) { if(SERIALOKAY) Serial.println(x); }
void print(unsigned long x) { if(SERIALOKAY) Serial.print(x); }
void println(void) { if(SERIALOKAY) Serial.println(""); }
void print(void) { if(SERIALOKAY) Serial.print(""); }

static bool pmu_irq = true;
bool button()
{
    bool rlst = false;
    //if (pmu_irq) {
        pmu_irq = false;
        watch->power->readIRQ();
        if (watch->power->isPEKShortPressIRQ()) {
            rlst = true;
      //  }
        watch->power->clearIRQ();
    }
    return rlst;
}

void clear()
{
    watch->tft->fillScreen(TFT_BLACK); // Clear screen  
}

bool sound()
{
    if (wav_generator->isRunning())
    {
        if (!wav_generator->loop()) wav_generator->stop();
        return false;
    }    
    else
    {
        file_wav = new AudioFileSourceFunction(1.);
        file_wav->addAudioGenerators(sine_wave);
        wav_generator->begin(file_wav, output_wav);
        return true;
    }    
}

float sine_wave_accZ(const float time) {
  //float v = sin(TWO_PI * (float)(absaccZ/3+300) * time);
  float tremolo = 11.f*sin(TWO_PI * ((float)absaccY*0.01f+1.f) * time);
  float v = sin(TWO_PI * ((float)(absaccZ/2) + 150.f + tremolo) * time);  // C
  
  //if(absaccX>300) v+=sin(TWO_PI * (float)absaccX * time);
  //if(absaccY>300) v+=sin(TWO_PI * (float)absaccY * time);
  //if(absaccZ>300) v+=sin(TWO_PI * (float)absaccZ * time);
  
//  v *= fmod(time, 0.01f);               // change linear
  v *= 0.15;                           // scale
  return v;
}

bool sound_accZ()
{
    if (wav_generator->isRunning())
    {
        if (!wav_generator->loop()) wav_generator->stop();
        return false;
    }    
    else
    {
        file_wav = new AudioFileSourceFunction(180.);
        file_wav->addAudioGenerators(sine_wave_accZ);
        wav_generator->begin(file_wav, output_wav);
        return true;
    }    
}


float sine_wave2(const float time) {
  float v = 0.f;
  if((int)time%2==0)
      v=sin(TWO_PI * 330.f * time) + sin(TWO_PI * 220.f * time);  // C
  else    
      v=sin(TWO_PI * 440.f * time) + sin(TWO_PI * 220.f * time);  // C
//  v *= fmod(time, 1.f);               // change linear
  v *= 0.25;                           // scale
  return v;
}

bool sound2()
{
    if (wav_generator->isRunning())
    {
        if (!wav_generator->loop()) wav_generator->stop();
        return false;
    }    
    else
    {
        file_wav = new AudioFileSourceFunction(10.);
        file_wav->addAudioGenerators(sine_wave2);
        wav_generator->begin(file_wav, output_wav);
        return true;
    }    
}


void endSound()
{
    if (wav_generator->isRunning())
    {
        if (!wav_generator->loop()) wav_generator->stop();
    }    
}

void stopSound()
{
    wav_generator->stop();
}


void updateTime()
{
    //Check if the RTC clock matches, if not, use compile time
    watch->rtc->check();

    //Synchronize time to system time
    watch->rtc->syncToSystem();
    // Get the current data
    
    tnow = watch->rtc->getDateTime();

    int hh = tnow.hour;
    int mm = tnow.minute;
    int ss = tnow.second;    
    int dday = tnow.day;
    int mmonth = tnow.month;
    int yyear = tnow.year;

    if(SERIALOKAY)
    {
        Serial.printf("Aktuelle Zeit von RTC:\n");
        Serial.printf("%d:%d:%d Uhr\n",hh,mm,ss);
        Serial.printf("day:%d month:%d year:%d\n",dday,mmonth,yyear);
    }

    _hh = hh;
    _mm = mm; 
    _ss = ss;

    LAST_RTC_MILLIS = millis();
}

//int getHour() {   return (_hh + (int)(((millis()-LAST_RTC_MILLIS)/3600000L))+(_ss*1000L)+(_mm*60000L))%24; }
//int getMinute() {   return (_mm + ((int)((millis()-LAST_RTC_MILLIS)/60000L))+(_ss*1000L))%60; }
//int getSecond() {   return (_ss + (int)((millis()-LAST_RTC_MILLIS)/1000L))%60; }

int getHour12() {   return   ((_hh%12L) + (int)(  (millis()-LAST_RTC_MILLIS+(_ss*1000L)+(_mm*60000L))  /3600000L)  )%12; }
int getHour() {   return   (_hh + (int)(  (millis()-LAST_RTC_MILLIS+(_ss*1000L)+(_mm*60000L))  /3600000L)  )%24; }
int getMinute() {   return (_mm + (int)(  (millis()-LAST_RTC_MILLIS+(_ss*1000L))               /60000L  )  )%60; }
int getSecond() {   return (_ss + (int)(  (millis()-LAST_RTC_MILLIS)                           /1000L   )  )%60; }

//int getHour() {   return (_hh + (int)((millis()-LAST_RTC_MILLIS)/3600000L))%24; }
//int getMinute() {   return (_mm + (int)((millis()-LAST_RTC_MILLIS)/60000L))%60; }
//int getSecond() {   return (_ss + (int)((millis()-LAST_RTC_MILLIS)/1000L))%60; }

void setupMotor()
{
     watch->motor_begin();       
}

void motor()
{
     watch->motor->onec();
}

bool setupWIFI(const char* ssid, const char* password, int udpport)
{
  UDPPORT = udpport;
  WiFi.begin(ssid, password);
  int COUNT=30;
  while( (WiFi.status() != WL_CONNECTED) && COUNT>0) 
  {
    delay(100);
    if(Serial) Serial.print(".");
    COUNT--;
  }

  if( (WiFi.status() != WL_CONNECTED) )
  {
      if(Serial) Serial.println("");
      if(Serial) Serial.println("NO WiFi!");    
      if(Serial) Serial.print("ssid:");    
      if(Serial) Serial.println(ssid);    
      if(Serial) Serial.print("pwd:");    
      if(Serial) Serial.println(password);  
      WIFIOKAY = false;  
      return false;
  }
  else
  {
      if(Serial) Serial.println("");
      if(Serial) Serial.println("WiFi connected");
      if(Serial) Serial.print("ip:");
      if(Serial) Serial.println(WiFi.localIP());
      WIFIOKAY = true;
      return true;
  }
}

bool setupSERIAL(long unsigned int baudrate)
{
    Serial.begin(baudrate);
    if(Serial)
    {
        SERIALOKAY = true;
        return true;
    }
    else
    {
        SERIALOKAY = false;
        return false;    
    }
}

bool touch()
{
    int16_t x,y;
    bool tch = watch->getTouch(x,y);
    mouseX=x;
    mouseY=y;
    return tch;
}

bool acceleration(void)
{
    Accel acc;
    bool res = sensor->getAccel(acc);
    accX = acc.x;
    accY = acc.y;
    accZ = acc.z;

    if(accX>=0) absaccX=accX; else absaccX=-accX;
    if(accY>=0) absaccY=accY; else absaccY=-accY;
    if(accZ>=0) absaccZ=accZ; else absaccZ=-accZ;
    
    return res;
}

void backlight(bool x) { if(x) hintergrundlicht->on(); else hintergrundlicht->off();}

void cursor(int x, int y) {tft->setCursor(x,y);}
void editor(char* text){ tft->print(text);}
void editor(char c){ tft->print(c);}
void editor(int x){ tft->print(x);}
void editor(unsigned int x){ tft->print(x);}
void editor(long x){ tft->print(x);}
void editor(unsigned long x){ tft->print(x);}
void editor(double x){ tft->print(x);}
void editor(float x){ tft->print(x);}
void editor(bool x){ if(x) tft->print("true"); else tft->print("false");}

void text(char* text, int x, int y)
{
    if(TEXT_ALIGN==NORMAL)
        tft->drawString(text,  x, y, FONT_NUMBER);     
    else if(TEXT_ALIGN==CENTER)
        tft->drawCentreString(text,  x, y, FONT_NUMBER);     
}

void textAlign(int x)
{
    TEXT_ALIGN = x;
}

void setFont(int x)
{  //x==0: 15x29 1:9x16(default) 2:5x8 3:3x4 Zeilen:Spalten
   if(x<4 && x>=0)
   {
     tft->setTextFont(x*2+2);
     FONT_NUMBER = x*2+2;
   }  
}
void setFont(int x, int R, int G, int B)
{  //x==0: 15x29 1:9x16(default) 2:5x8 3:3x4 Zeilen:Spalten
   if(x<4 && x>=0)
   {
     tft->setTextColor(((255>>4))+((R>>4)<<12)+((G>>4)<<8)+((B>>4)<<4), TFT_BLACK);    
     tft->setTextFont(x*2+2);
     FONT_NUMBER = x*2+2;
   }  
}
void setFont(int x, int R, int G, int B, int RH, int GH, int BH)
{  //x==0: 15x29 1:9x16(default) 2:5x8 3:3x4 Zeilen:Spalten
   if(x<4 && x>=0)
   {
     tft->setTextColor(((255>>4))+((R>>4)<<12)+((G>>4)<<8)+((B>>4)<<4), ((255>>4))+((RH>>4)<<12)+((GH>>4)<<8)+((BH>>4)<<4));        
     tft->setTextFont(x*2+2);
     FONT_NUMBER = x*2+2;
   }  
}
//siehe /home/fhbstud/TWATCH/TTGO_TWatch_Library-1.4.3/src/libraries/TFT_eSPI/TFT_eSPI.h:
             //                 Corner 1               Corner 2               Corner 3
           //drawTriangle(int32_t x1, int32_t y1, int32_t x2, int32_t y2, int32_t x3, int32_t y3, uint32_t color),
           //fillTriangle(int32_t x1, int32_t y1, int32_t x2, int32_t y2, int32_t x3, int32_t y3, uint32_t color);

void triangle(int x1, int y1, int x2, int y2, int x3, int y3)
{
  if(FILL_ALLOW)
  {
    tft->fillTriangle(x1,y1,x2,y2,x3,y3,   

    ((FILL_ALPHA>>4))+((FILL_RED>>4)<<12)+((FILL_GREEN>>4)<<8)+((FILL_BLUE>>4)<<4)
    
    );
  }  
  if(STROKE_ALLOW)
  {
    tft->drawTriangle(x1,y1,x2,y2,x3,y3,   

    ((STROKE_ALPHA>>4))+((STROKE_RED>>4)<<12)+((STROKE_GREEN>>4)<<8)+((STROKE_BLUE>>4)<<4)
    
    );
  }  
}


void rect(int x, int y, int w, int h)
{
  if(FILL_ALLOW)
  {
    tft->fillRect(x, y, w, h,   

    ((FILL_ALPHA>>4))+((FILL_RED>>4)<<12)+((FILL_GREEN>>4)<<8)+((FILL_BLUE>>4)<<4)
    
    );
  }  
  if(STROKE_ALLOW)
  {
    tft->drawRect(x, y, w, h,   

    ((STROKE_ALPHA>>4))+((STROKE_RED>>4)<<12)+((STROKE_GREEN>>4)<<8)+((STROKE_BLUE>>4)<<4)
    
    );
  }  
}

// drawLine(int32_t xs, int32_t ys, int32_t xe, int32_t ye, uint32_t color),
void line(int x1, int y1, int x2, int y2, int R, int G, int B)
{
    tft->drawLine(x1, y1, x2, y2, 
    ((255>>4))+((R>>4)<<12)+((G>>4)<<8)+((B>>4)<<4)
    
    );
}
void line(int x1, int y1, int x2, int y2)
{
    tft->drawLine(x1, y1, x2, y2, 
    ((STROKE_ALPHA>>4))+((STROKE_RED>>4)<<12)+((STROKE_GREEN>>4)<<8)+((STROKE_BLUE>>4)<<4)
    
    );

}

void circle(int x, int y, int r)
{
  if(FILL_ALLOW)
  {
    tft->fillCircle(x, y, r,   

    ((FILL_ALPHA>>4))+((FILL_RED>>4)<<12)+((FILL_GREEN>>4)<<8)+((FILL_BLUE>>4)<<4)
    
    );
  }  
  if(STROKE_ALLOW)
  {
    tft->drawCircle(x, y, r,   

    ((STROKE_ALPHA>>4))+((STROKE_RED>>4)<<12)+((STROKE_GREEN>>4)<<8)+((STROKE_BLUE>>4)<<4)
    
    );
  }  
}


void background(int ALPHA, int RED, int GREEN, int BLUE)
{ tft->fillScreen(((ALPHA>>4))+((RED>>4)<<12)+((GREEN>>4)<<8)+((BLUE>>4)<<4)); }
void background(int RED, int GREEN, int BLUE)
{ tft->fillScreen(((255>>4))+((RED>>4)<<12)+((GREEN>>4)<<8)+((BLUE>>4)<<4)); }
void background(int ALPHA, int GREY)
{ tft->fillScreen(((ALPHA>>4))+((GREY>>4)<<12)+((GREY>>4)<<8)+((GREY>>4)<<4)); }
void background(int GREY)
{ tft->fillScreen(((255>>4))+((GREY>>4)<<12)+((GREY>>4)<<8)+((GREY>>4)<<4)); }

void noFill(void)
{
    FILL_ALPHA = 0;
    FILL_ALLOW=false;
}

void noStroke(void)
{
    STROKE_ALPHA = 0;
    STROKE_ALLOW=false;
}

void fill(int ALPHA, int RED, int GREEN, int BLUE)
{
    FILL_ALLOW = true;
    FILL_ALPHA = ALPHA;
    FILL_RED   = RED;
    FILL_GREEN = GREEN;
    FILL_BLUE  = BLUE;
}

void fill(int RED, int GREEN, int BLUE)
{
    FILL_ALLOW = true;
    FILL_ALPHA = 255;
    FILL_RED   = RED;
    FILL_GREEN = GREEN;
    FILL_BLUE  = BLUE;
}

void fill(int ALPHA, int GREY)
{
    FILL_ALLOW = true;
    FILL_ALPHA = ALPHA;
    FILL_RED   = GREY;
    FILL_GREEN = GREY;
    FILL_BLUE  = GREY;
}

void fill(int GREY)
{
    FILL_ALLOW = true;
    FILL_ALPHA = 255;
    FILL_RED   = GREY;
    FILL_GREEN = GREY;
    FILL_BLUE  = GREY;
}

void stroke(int ALPHA, int RED, int GREEN, int BLUE)
{
    STROKE_ALLOW = true;
    STROKE_ALPHA = ALPHA;
    STROKE_RED   = RED;
    STROKE_GREEN = GREEN;
    STROKE_BLUE  = BLUE;
}

void stroke(int RED, int GREEN, int BLUE)
{
    STROKE_ALLOW = true;
    STROKE_ALPHA = 255;
    STROKE_RED   = RED;
    STROKE_GREEN = GREEN;
    STROKE_BLUE  = BLUE;
}

void stroke(int ALPHA, int GREY)
{
    STROKE_ALLOW = true;
    STROKE_ALPHA = ALPHA;
    STROKE_RED   = GREY;
    STROKE_GREEN = GREY;
    STROKE_BLUE  = GREY;
}

void stroke(int GREY)
{
    STROKE_ALLOW = true;
    STROKE_ALPHA = 255;
    STROKE_RED   = GREY;
    STROKE_GREEN = GREY;
    STROKE_BLUE  = GREY;
}
